/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.upgrade;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.gui.component.FilterGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.proxy.block.Cuboid;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ConveyorInsertionUpgrade
extends ConveyorUpgrade {
    public static Cuboid NORTHBB = new Cuboid(0.125, 0.0, -0.125, 0.875, 0.5625, 0.125, EnumFacing.NORTH.func_176745_a());
    public static Cuboid SOUTHBB = new Cuboid(0.125, 0.0, 0.875, 0.875, 0.5625, 1.125, EnumFacing.SOUTH.func_176745_a());
    public static Cuboid EASTBB = new Cuboid(0.875, 0.0, 0.125, 1.125, 0.5625, 0.875, EnumFacing.EAST.func_176745_a());
    public static Cuboid WESTBB = new Cuboid(-0.125, 0.0, 0.125, 0.125, 0.5625, 0.875, EnumFacing.WEST.func_176745_a());
    public static Cuboid NORTHBB_BIG = new Cuboid(0.125, 0.0, -0.125, 0.875, 0.5625, 0.875, EnumFacing.NORTH.func_176745_a());
    public static Cuboid SOUTHBB_BIG = new Cuboid(0.125, 0.0, 0.125, 0.875, 0.5625, 1.125, EnumFacing.SOUTH.func_176745_a());
    public static Cuboid EASTBB_BIG = new Cuboid(0.125, 0.0, 0.125, 1.125, 0.5625, 0.875, EnumFacing.EAST.func_176745_a());
    public static Cuboid WESTBB_BIG = new Cuboid(-0.125, 0.0, 0.125, 0.875, 0.5625, 0.875, EnumFacing.WEST.func_176745_a());
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean whitelist = false;
    private boolean fullArea = false;

    public ConveyorInsertionUpgrade(IConveyorContainer container, ConveyorUpgradeFactory factory, EnumFacing side) {
        super(container, factory, side);
    }

    @Override
    public void handleEntity(Entity entity) {
        IItemHandler handler;
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (entity instanceof EntityItem && (handler = this.getHandlerCapability()) != null && this.getWorkingBox().aabb().func_186670_a(this.getPos()).func_186662_g(0.01).func_72326_a(entity.func_174813_aQ())) {
            if (this.whitelist != this.filter.matches((Entity)((EntityItem)entity))) {
                return;
            }
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack remaining = handler.insertItem(i, stack, false);
                if (remaining.func_190926_b()) {
                    entity.func_70106_y();
                    break;
                }
                ((EntityItem)entity).func_92058_a(remaining);
            }
        }
    }

    @Nullable
    private IItemHandler getHandlerCapability() {
        BlockPos offsetPos = this.getPos().func_177972_a(this.getSide());
        TileEntity tile = this.getWorld().func_175625_s(offsetPos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().func_176734_d())) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().func_176734_d());
        }
        Iterator iterator = this.getWorld().func_175647_a(Entity.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(offsetPos), EntitySelectors.field_180132_d).iterator();
        while (iterator.hasNext()) {
            Entity entity;
            if (!entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (entity = (Entity)iterator.next()) instanceof EntityPlayerMP ? null : this.getSide().func_176734_d())) continue;
            return (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, entity instanceof EntityPlayerMP ? null : this.getSide().func_176734_d());
        }
        return null;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT() == null ? new NBTTagCompound() : super.serializeNBT();
        compound.func_74782_a("Filter", (NBTBase)this.filter.serializeNBT());
        compound.func_74757_a("Whitelist", this.whitelist);
        compound.func_74757_a("FullArea", this.fullArea);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("Filter")) {
            this.filter.deserializeNBT(nbt.func_74775_l("Filter"));
        }
        this.whitelist = nbt.func_74767_n("Whitelist");
        this.fullArea = nbt.func_74767_n("FullArea");
    }

    @Override
    public Cuboid getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTHBB;
            }
            case SOUTH: {
                return SOUTHBB;
            }
            case EAST: {
                return EASTBB;
            }
            case WEST: 
        }
        return WESTBB;
    }

    private Cuboid getWorkingBox() {
        if (!this.fullArea) {
            return this.getBoundingBox();
        }
        switch (this.getSide()) {
            default: {
                return NORTHBB_BIG;
            }
            case SOUTH: {
                return SOUTHBB_BIG;
            }
            case EAST: {
                return EASTBB_BIG;
            }
            case WEST: 
        }
        return WESTBB_BIG;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, NBTTagCompound compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, new ItemStack(compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 17) {
            this.fullArea = !this.fullArea;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorInsertionUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorInsertionUpgrade.this.whitelist ? 0 : 1;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(17, 133, 55, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 39, 214, new String[]{"insert_near"}), new StateButtonInfo(1, res, 58, 214, new String[]{"insert_all"})}){

            @Override
            public int getState() {
                return ConveyorInsertionUpgrade.this.fullArea ? 1 : 0;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("insertion");
        }

        @Override
        public ConveyorUpgrade create(IConveyorContainer container, EnumFacing face) {
            return new ConveyorInsertionUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(EnumFacing upgradeSide, EnumFacing conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_inserter_" + upgradeSide.func_176610_l().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_insertion_upgrade");
        }
    }
}

