/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.upgrade;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.gui.component.FilterGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.proxy.block.Cuboid;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ConveyorDroppingUpgrade
extends ConveyorUpgrade {
    public static Cuboid BB = new Cuboid(0.1875, 0.0625, 0.1875, 0.8125, 0.075, 0.8125, EnumFacing.DOWN.func_176745_a(), false);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean whitelist = false;

    public ConveyorDroppingUpgrade(IConveyorContainer container, ConveyorUpgradeFactory factory, EnumFacing side) {
        super(container, factory, side);
    }

    @Override
    public void handleEntity(Entity entity) {
        TileEntity tile;
        super.handleEntity(entity);
        if (entity instanceof EntityPlayer) {
            return;
        }
        if (this.whitelist != this.filter.matches(entity)) {
            return;
        }
        if (entity instanceof EntityItem && (tile = this.getWorld().func_175625_s(this.getPos().func_177972_a(EnumFacing.DOWN))) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            if (this.getBoundingBox().aabb().func_186670_a(this.getPos()).func_186662_g(0.01).func_72326_a(entity.func_174813_aQ())) {
                ItemStack stack = ((EntityItem)entity).func_92059_d();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack remaining = handler.insertItem(i, stack, false);
                    if (remaining.func_190926_b()) {
                        entity.func_70106_y();
                        break;
                    }
                    ((EntityItem)entity).func_92058_a(remaining);
                }
            }
        }
        if (entity.field_70128_L) {
            return;
        }
        double entityHeight = entity.func_174813_aQ().field_72337_e - entity.func_174813_aQ().field_72338_b;
        BlockPos pos = this.getPos().func_177979_c((int)Math.ceil(entityHeight));
        boolean space = true;
        for (int y = pos.func_177956_o(); y < this.getPos().func_177956_o(); ++y) {
            if (this.getWorld().func_175623_d(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()))) continue;
            space = false;
            break;
        }
        if (space) {
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.1, (double)pos.func_177952_p() + 0.5);
            entity.field_70122_E = false;
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT() == null ? new NBTTagCompound() : super.serializeNBT();
        compound.func_74782_a("Filter", (NBTBase)this.filter.serializeNBT());
        compound.func_74757_a("Whitelist", this.whitelist);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("Filter")) {
            this.filter.deserializeNBT(nbt.func_74775_l("Filter"));
        }
        this.whitelist = nbt.func_74767_n("Whitelist");
    }

    @Override
    public Cuboid getBoundingBox() {
        return BB;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, NBTTagCompound compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, new ItemStack(compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorDroppingUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorDroppingUpgrade.this.whitelist ? 0 : 1;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("dropping");
        }

        @Override
        public ConveyorUpgrade create(IConveyorContainer container, EnumFacing face) {
            return new ConveyorDroppingUpgrade(container, this, face);
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Collections.singleton(new ResourceLocation("industrialforegoing", "blocks/conveyor_dropping_upgrade"));
        }

        @Override
        @Nonnull
        public Set<EnumFacing> getValidFacings() {
            return DOWN;
        }

        @Override
        public EnumFacing getSideForPlacement(World world, BlockPos pos, EntityPlayer player) {
            return EnumFacing.DOWN;
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(EnumFacing upgradeSide, EnumFacing conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_dropping");
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_dropping_upgrade");
        }
    }
}

