/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.struct.PatternBlockArray;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileStructController
extends TileEntityTick {
    private StructType type;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticksExisted % 60 == 0) {
                if (this.type == null) {
                    this.field_145850_b.func_175698_g(this.field_174879_c);
                } else {
                    PatternBlockArray match = (PatternBlockArray)this.type.matchProvider.apply(null);
                    if (match == null || !match.matches(this.field_145850_b, this.field_174879_c.func_177979_c(3))) {
                        this.field_145850_b.func_175698_g(this.field_174879_c);
                    }
                }
            }
        } else {
            this.playAmbientEffects();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playAmbientEffects() {
        if (!ConstellationSkyHandler.getInstance().isNight(this.field_145850_b) || rand.nextInt(5) != 0) {
            return;
        }
        if (this.type == null) {
            return;
        }
        if (this.type == StructType.GATE) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).gravity(0.004);
            p.offset((double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1));
            p.scale(0.2f + rand.nextFloat() * 0.1f).setAlphaMultiplier(0.8f);
            p.motion(rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1)).setMaxAge(30 + rand.nextInt(20));
            p.setColor(new Color(3932415));
            if (rand.nextBoolean()) {
                Vector3 offset = new Vector3((double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.1 * (double)(rand.nextBoolean() ? 1 : -1));
                p = EffectHelper.genericFlareParticle((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).gravity(0.004);
                p.offset(offset.getX(), offset.getY(), offset.getZ());
                p.scale(0.1f + rand.nextFloat() * 0.1f).setAlphaMultiplier(0.8f);
                p.motion(0.0, 0.0, 0.0).setMaxAge(30 + rand.nextInt(20));
                p.setColor(new Color(3932415));
                p = EffectHelper.genericFlareParticle((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).gravity(0.004);
                p.offset(offset.getX(), offset.getY(), offset.getZ());
                p.scale(0.05f + rand.nextFloat() * 0.05f).setAlphaMultiplier(0.8f);
                p.motion(0.0, 0.0, 0.0).setMaxAge(30 + rand.nextInt(20));
                p.setColor(Color.WHITE);
            }
            if (rand.nextInt(35) == 0) {
                Vector3 posFrom = new Vector3(this.func_174877_v()).add(0.4 + (double)rand.nextFloat() * 0.2, 0.4 + (double)rand.nextFloat() * 0.2, 0.4 + (double)rand.nextFloat() * 0.2);
                Vector3 posTo = new Vector3(this.func_174877_v()).addZ(rand.nextBoolean() ? 2.0 : -1.0);
                posTo.addY(-1.0f + rand.nextFloat() * 3.0f).addX(rand.nextFloat());
                EffectHandler.getInstance().lightning(posFrom, posTo).setOverlayColor(new Color(3932415));
            }
        } else if (this.type == StructType.SUPPORT) {
            // empty if block
        }
    }

    public void setType(StructType type) {
        this.type = type;
    }

    @Override
    public void onFirstTick() {
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.type = StructType.values()[MathHelper.func_76125_a((int)compound.func_74762_e("structtype"), (int)0, (int)1)];
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("structtype", this.type.ordinal());
    }

    public static enum StructType {
        GATE(v -> MultiBlockArrays.patternSmallRuin),
        SUPPORT(v -> null),
        ARC(v -> null),
        LENS(v -> null),
        CORE(v -> null);

        private Function<Void, PatternBlockArray> matchProvider;

        private StructType(Function<Void, PatternBlockArray> matchProvider) {
            this.matchProvider = matchProvider;
        }
    }
}

