/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileGrindstone
extends TileEntitySynchronized
implements ITickable {
    public static final int TICKS_WHEEL_ROTATION = 20;
    private ItemStack grindingItem = ItemStack.field_190927_a;
    public int tickWheelAnimation = 0;
    public int prevTickWheelAnimation = 0;
    private boolean repeat = false;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.tickWheelAnimation > 0) {
                this.prevTickWheelAnimation = this.tickWheelAnimation--;
                if (this.tickWheelAnimation <= 0 && this.repeat) {
                    this.tickWheelAnimation = 20;
                    this.prevTickWheelAnimation = 21;
                    this.repeat = false;
                }
            } else {
                this.prevTickWheelAnimation = 0;
                this.tickWheelAnimation = 0;
            }
        }
    }

    public void playWheelEffect() {
        PktPlayEffect effect = new PktPlayEffect(PktPlayEffect.EffectType.GRINDSTONE_WHEEL, this.func_174877_v());
        if (this.field_145850_b.field_72995_K) {
            TileGrindstone.playWheelAnimation(effect);
        } else {
            PacketChannel.CHANNEL.sendToAllAround((IMessage)effect, PacketChannel.pointFromPos(this.field_145850_b, (Vec3i)this.func_174877_v(), 32.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playWheelAnimation(PktPlayEffect pktPlayEffect) {
        TileGrindstone tgr = MiscUtils.getTileAt((IBlockAccess)Minecraft.func_71410_x().field_71441_e, pktPlayEffect.pos, TileGrindstone.class, false);
        if (tgr != null) {
            if (tgr.tickWheelAnimation == 0) {
                tgr.tickWheelAnimation = 20;
            } else if (tgr.tickWheelAnimation * 2 <= 20) {
                tgr.repeat = true;
            }
        }
    }

    public void setGrindingItem(@Nonnull ItemStack stack) {
        this.grindingItem = stack;
        this.markForUpdate();
    }

    @Nonnull
    public ItemStack getGrindingItem() {
        return this.grindingItem;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        NBTTagCompound itemTag = compound.func_74775_l("item");
        this.grindingItem = itemTag.func_186856_d() <= 0 ? ItemStack.field_190927_a : new ItemStack(itemTag);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        NBTTagCompound itemTag = new NBTTagCompound();
        this.grindingItem.func_77955_b(itemTag);
        compound.func_74782_a("item", (NBTBase)itemTag);
    }
}

