/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.entry;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class WorldGenEntry
extends ConfigEntry {
    private int generationChance;
    private boolean doGenerate = false;
    private boolean doIgnoreBiomeSpecifications = false;
    private boolean doIgnoreDimensionSpecifications = true;
    private BiomeDictionary.Type[] defaultBiomeTypes;
    private List<BiomeDictionary.Type> biomeTypes = new ArrayList<BiomeDictionary.Type>();
    private List<Integer> applicableDimensions = new ArrayList<Integer>();
    private int minY;
    private int maxY;
    private boolean loaded = false;

    public WorldGenEntry(String key, int defaultChance, boolean ignoreBiomeSpecifications, BiomeDictionary.Type ... applicableTypes) {
        super(ConfigEntry.Section.WORLDGEN, key);
        this.doIgnoreBiomeSpecifications = ignoreBiomeSpecifications;
        this.generationChance = defaultChance;
        this.defaultBiomeTypes = applicableTypes;
        this.minY = 0;
        this.maxY = 255;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        this.doGenerate = cfg.getBoolean("Generate", this.getConfigurationSection(), true, "Generate " + this.getKey());
        this.doIgnoreBiomeSpecifications = cfg.getBoolean("IgnoreBiomes", this.getConfigurationSection(), this.doIgnoreBiomeSpecifications, "Ignore Biome specifications when trying to generate " + this.getKey());
        this.doIgnoreDimensionSpecifications = cfg.getBoolean("IgnoreDimensionSettings", this.getConfigurationSection(), this.doIgnoreDimensionSpecifications, "Ignore dimension-whitelist when trying to generate " + this.getKey());
        this.generationChance = cfg.getInt("Chance", this.getConfigurationSection(), this.generationChance, 1, Integer.MAX_VALUE, "Chance to generate the structure in a chunk. The higher, the lower the chance.");
        this.minY = cfg.getInt("MinY", this.getConfigurationSection(), this.minY, 0, 255, "Set the minimum Y level to spawn this structure on");
        this.maxY = cfg.getInt("MaxY", this.getConfigurationSection(), this.maxY, 0, 255, "Set the maximum Y level to spawn this structure on");
        String[] strTypes = cfg.getStringList("BiomeTypes", this.getConfigurationSection(), this.getDefaultBiomeTypes(), "Set the BiomeTypes (according to the BiomeDicitionary) this structure will spawn in.");
        LinkedList<BiomeDictionary.Type> resolvedTypes = new LinkedList<BiomeDictionary.Type>();
        for (String s : strTypes) {
            try {
                resolvedTypes.add(BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
            }
            catch (Exception e) {
                AstralSorcery.log.error("[AstralSorcery] Could not find BiomeType by name '" + s + "' - Ignoring BiomeType specification for structure " + this.getKey());
            }
        }
        this.biomeTypes = Lists.newArrayList(resolvedTypes);
        String[] dimensionWhitelist = cfg.getStringList("DimensionWhitelist", this.getConfigurationSection(), new String[0], "Define an array of dimensionID's where the structure is allowed to spawn in.");
        this.applicableDimensions = new ArrayList<Integer>();
        for (String s : dimensionWhitelist) {
            try {
                this.applicableDimensions.add(Integer.parseInt(s));
            }
            catch (NumberFormatException exc) {
                AstralSorcery.log.error("[AstralSorcery] Could not add " + s + " to dimension whitelist for " + this.getKey() + " - It is not a number!");
            }
        }
        this.loaded = true;
    }

    @Override
    public String getConfigurationSection() {
        return super.getConfigurationSection() + "." + this.getKey();
    }

    private String[] getDefaultBiomeTypes() {
        String[] def = new String[this.defaultBiomeTypes.length];
        for (int i = 0; i < this.defaultBiomeTypes.length; ++i) {
            BiomeDictionary.Type t = this.defaultBiomeTypes[i];
            def[i] = t.getName();
        }
        return def;
    }

    public void setMinY(int minY) {
        if (this.loaded) {
            return;
        }
        this.minY = minY;
    }

    public void setMaxY(int maxY) {
        if (this.loaded) {
            return;
        }
        this.maxY = maxY;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public List<BiomeDictionary.Type> getTypes() {
        return this.biomeTypes;
    }

    public List<Integer> getApplicableDimensions() {
        return this.applicableDimensions;
    }

    public boolean shouldIgnoreDimensionSpecifications() {
        return this.doIgnoreDimensionSpecifications;
    }

    public boolean shouldGenerate() {
        return this.doGenerate;
    }

    public boolean shouldIgnoreBiomeSpecifications() {
        return this.doIgnoreBiomeSpecifications;
    }

    public boolean tryGenerate(Random random, double chanceMultiplier) {
        return random.nextInt(Math.max((int)Math.round((double)this.generationChance * chanceMultiplier), 1)) == 0;
    }
}

