/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;

public class PerkDestructionDamageArc
extends ConstellationPerk {
    private static AxisAlignedBB searchBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static float arcChance = 0.75f;
    private static float arcPercent = 1.75f;
    private static float distanceSearch = 4.0f;
    private static boolean chaining = false;

    public PerkDestructionDamageArc() {
        super("DTR_DAMAGEARC", ConstellationPerk.Target.ENTITY_ATTACK);
    }

    @Override
    public float onEntityAttack(EntityPlayer attacker, EntityLivingBase attacked, float dmgIn) {
        if (!attacked.func_130014_f_().field_72995_K && attacked.func_130014_f_() instanceof WorldServer && !chaining && rand.nextFloat() < arcChance) {
            EntityLivingBase closest;
            List entities = attacked.func_130014_f_().func_175647_a(EntityLivingBase.class, searchBox.func_191194_a(attacked.func_174791_d()), EntityUtils.selectEntities(EntityLivingBase.class));
            entities.remove(attacked);
            entities.remove(attacker);
            if (!attacker.func_130014_f_().func_73046_m().func_71219_W()) {
                entities.removeIf(e -> e instanceof EntityPlayer);
            }
            if (!entities.isEmpty() && (closest = EntityUtils.selectClosest(entities, e -> e.func_70032_d((Entity)attacked))) != null && !closest.field_70128_L) {
                chaining = true;
                AstralSorcery.proxy.fireLightning(attacked.func_130014_f_(), Vector3.atEntityCorner((Entity)attacked), Vector3.atEntityCorner((Entity)closest), Color.WHITE);
                attacked.func_70097_a((DamageSource)CommonProxy.dmgSourceStellar.setSource((EntityLivingBase)attacker), arcPercent * dmgIn);
                closest.func_70097_a((DamageSource)CommonProxy.dmgSourceStellar.setSource((EntityLivingBase)attacker), arcPercent * dmgIn);
                chaining = false;
            }
        }
        return dmgIn;
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        arcChance = cfg.getFloat(this.getKey() + "ArcChance", this.getConfigurationSection(), arcChance, 0.0f, 1.0f, "Defines the chance for an arc to happen at all");
        arcPercent = cfg.getFloat(this.getKey() + "ArcDamagePercent", this.getConfigurationSection(), arcPercent, 0.0f, 32.0f, "Defines, if an damage-arc happens, how much damage it'll deal to both entities. Multiplicative off of the damage of the original attack.");
        float search = cfg.getFloat(this.getKey() + "ArcDistance", this.getConfigurationSection(), distanceSearch, 1.0f, 16.0f, "Defines the radius in which the arc-logic will search for an entity to arc damage towards.");
        searchBox = new AxisAlignedBB((double)(-search), (double)(-search), (double)(-search), (double)search, (double)search, (double)search);
    }
}

