/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.CropHelper;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class PerkCreationGrowables
extends ConstellationPerk {
    private static int chanceToBonemeal = 6;

    public PerkCreationGrowables() {
        super("CRE_GROWTH", ConstellationPerk.Target.PLAYER_TICK);
    }

    @Override
    public void onPlayerTick(EntityPlayer player, Side side) {
        if (side == Side.SERVER && rand.nextInt(chanceToBonemeal) == 0) {
            BlockPos pos = player.func_180425_c().func_177982_a(rand.nextInt(4) - 2, rand.nextInt(4) - 2, rand.nextInt(4) - 2);
            World w = player.func_130014_f_();
            CropHelper.GrowablePlant plant = CropHelper.wrapPlant(w, pos);
            PktParticleEvent pkt = null;
            if (plant != null) {
                if (plant.tryGrow(w, rand)) {
                    pkt = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_CROP_INTERACT, (Vec3i)pos);
                    this.addAlignmentCharge(player, 0.4);
                }
            } else {
                IBlockState at = w.func_180495_p(pos);
                if (at.func_177230_c() instanceof BlockDirt && ((BlockDirt.DirtType)at.func_177229_b((IProperty)BlockDirt.field_176386_a)).equals((Object)BlockDirt.DirtType.DIRT)) {
                    w.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
                    pkt = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_CROP_INTERACT, (Vec3i)pos);
                    this.addAlignmentCharge(player, 0.2);
                }
            }
            if (pkt != null) {
                PacketChannel.CHANNEL.sendToAllAround((IMessage)pkt, PacketChannel.pointFromPos(w, (Vec3i)pos, 16.0));
            }
        }
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        chanceToBonemeal = cfg.getInt(this.getKey() + "ChanceForBonemeal", this.getConfigurationSection(), chanceToBonemeal, 2, 4000, "Sets the chance (Random.nextInt(chance) == 0) to try to see if a random plant near the player gets bonemeal'd");
    }
}

