/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.common.base.MeltInteraction;
import hellfirepvp.astralsorcery.common.constellation.effect.GenListEntries;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public enum WorldMeltables implements MeltInteraction
{
    COBBLE(new BlockStateCheck.Block(Blocks.field_150347_e), Blocks.field_150356_k.func_176223_P(), 180),
    STONE(new BlockStateCheck.Block(Blocks.field_150348_b), Blocks.field_150356_k.func_176223_P(), 100),
    OBSIDIAN(new BlockStateCheck.Block(Blocks.field_150343_Z), Blocks.field_150356_k.func_176223_P(), 75),
    NETHERRACK(new BlockStateCheck.Block(Blocks.field_150424_aL), Blocks.field_150356_k.func_176223_P(), 40),
    NETHERBRICK(new BlockStateCheck.Block(Blocks.field_150385_bj), Blocks.field_150356_k.func_176223_P(), 60),
    MAGMA(new BlockStateCheck.Block(Blocks.field_189877_df), Blocks.field_150356_k.func_176223_P(), 1),
    ICE(new BlockStateCheck.Block(Blocks.field_150432_aD), Blocks.field_150358_i.func_176223_P(), 1),
    FROSTED_ICE(new BlockStateCheck.Block(Blocks.field_185778_de), Blocks.field_150358_i.func_176223_P(), 1),
    PACKED_ICE(new BlockStateCheck.Block(Blocks.field_150403_cj), Blocks.field_150358_i.func_176223_P(), 2);

    private final BlockStateCheck meltableCheck;
    private final IBlockState meltResult;
    private final int meltDuration;

    private WorldMeltables(BlockStateCheck meltableCheck, IBlockState meltResult, int meltDuration) {
        this.meltableCheck = meltableCheck;
        this.meltResult = meltResult;
        this.meltDuration = meltDuration;
    }

    @Override
    public boolean isMeltable(World world, BlockPos pos, IBlockState worldState) {
        return this.meltableCheck.isStateValid(world, pos, worldState);
    }

    @Override
    @Nullable
    public IBlockState getMeltResultState() {
        return this.meltResult;
    }

    @Override
    @Nonnull
    public ItemStack getMeltResultStack() {
        return ItemStack.field_190927_a;
    }

    @Override
    public int getMeltTickDuration() {
        return this.meltDuration;
    }

    @Nullable
    public static MeltInteraction getMeltable(World world, BlockPos pos) {
        ItemStack out;
        IBlockState state = world.func_180495_p(pos);
        for (WorldMeltables melt : WorldMeltables.values()) {
            if (!melt.isMeltable(world, pos, state)) continue;
            return melt;
        }
        ItemStack stack = ItemUtils.createBlockStack(state);
        if (!stack.func_190926_b() && !(out = FurnaceRecipes.func_77602_a().func_151395_a(stack)).func_190926_b()) {
            return new FurnaceRecipeInteraction(state, out);
        }
        return null;
    }

    public static class FurnaceRecipeInteraction
    implements MeltInteraction {
        private final ItemStack out;
        private final BlockStateCheck.Meta matchInState;

        public FurnaceRecipeInteraction(IBlockState inState, ItemStack outStack) {
            this.matchInState = new BlockStateCheck.Meta(inState.func_177230_c(), inState.func_177230_c().func_176201_c(inState));
            this.out = outStack;
        }

        @Override
        public boolean isMeltable(World world, BlockPos pos, IBlockState state) {
            return this.matchInState.isStateValid(world, pos, state);
        }

        @Override
        @Nullable
        public IBlockState getMeltResultState() {
            return ItemUtils.createBlockState(this.out);
        }

        @Override
        @Nonnull
        public ItemStack getMeltResultStack() {
            return this.out.func_77946_l();
        }
    }

    public static class ActiveMeltableEntry
    extends GenListEntries.CounterListEntry {
        public ActiveMeltableEntry(BlockPos pos) {
            super(pos);
        }

        public boolean isValid(World world, boolean forceLoad) {
            if (!forceLoad && !MiscUtils.isChunkLoaded(world, new ChunkPos(this.getPos()))) {
                return true;
            }
            return this.getMeltable(world) != null;
        }

        public MeltInteraction getMeltable(World world) {
            return WorldMeltables.getMeltable(world, this.getPos());
        }
    }
}

