/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionChain;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.tile.base.TileNetwork;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class StarlightNetworkDebugHandler
implements ITickHandler {
    public static final StarlightNetworkDebugHandler INSTANCE = new StarlightNetworkDebugHandler();
    private Map<UUID, Tuple<Integer, Runnable>> playerAwaitingDebugMode = new HashMap<UUID, Tuple<Integer, Runnable>>();

    private StarlightNetworkDebugHandler() {
    }

    public void awaitDebugInteraction(EntityPlayer player, Runnable timeoutRunnable) {
        this.playerAwaitingDebugMode.put(player.func_110124_au(), (Tuple<Integer, Runnable>)new Tuple((Object)400, (Object)timeoutRunnable));
    }

    public boolean beginDebugFor(World world, BlockPos pos, EntityPlayer player) {
        if (!this.playerAwaitingDebugMode.containsKey(player.func_110124_au())) {
            return false;
        }
        WorldNetworkHandler wnh = WorldNetworkHandler.getNetworkHandler(world);
        TransmissionWorldHandler twh = StarlightTransmissionHandler.getInstance().getWorldHandler(world);
        TileEntity te = MiscUtils.getTileAt((IBlockAccess)world, pos, TileEntity.class, false);
        IPrismTransmissionNode tr = wnh.getTransmissionNode(pos);
        player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aPrinting debug for..."));
        player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aWorld-ID:\u00c2\u00a7c " + world.field_73011_w.getDimension()));
        player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aPos:\u00c2\u00a7c " + pos.toString()));
        player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aTile found:\u00c2\u00a7c " + (te == null ? "null" : te.getClass().getName())));
        if (twh == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7cWorld is missing a starlight-transmission handler! Is this world not ticking?"));
        }
        if (te != null) {
            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aIs Network-Tile:\u00c2\u00a7c " + (te instanceof TileNetwork)));
            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aIs Starlight-Transmission-Tile:\u00c2\u00a7c " + (te instanceof IStarlightTransmission)));
        }
        player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aIs Transmission-Node present:\u00c2\u00a7c " + (tr != null)));
        if (tr != null) {
            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aFull Transmission-Node class:\u00c2\u00a7c " + tr.getClass().getName()));
            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aInternal Transmission-Node position:\u00c2\u00a7c " + tr.getPos().toString()));
            List<BlockPos> sources = tr.getSources();
            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aTransmission-Node Network-Source-Positions:"));
            if (sources.isEmpty()) {
                player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7cNONE"));
            }
            for (BlockPos blockPos : sources) {
                player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7c" + blockPos.toString()));
            }
            List<NodeConnection<IPrismTransmissionNode>> next = tr.queryNext(wnh);
            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aTransmission-Node next links:"));
            if (next.isEmpty()) {
                player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7cNONE"));
            }
            for (NodeConnection<IPrismTransmissionNode> nodeConnection : next) {
                player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7c" + nodeConnection.getTo() + "\u00c2\u00a7a - canSee/connected:\u00c2\u00a7c " + nodeConnection.canConnect()));
            }
            if (tr instanceof ITransmissionSource) {
                IIndependentStarlightSource iIndependentStarlightSource = wnh.getSourceAt(tr.getPos());
                if (iIndependentStarlightSource != null) {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aFound starlight source:\u00c2\u00a7c " + iIndependentStarlightSource.getClass().getName()));
                    if (twh != null) {
                        TransmissionChain transmissionChain = twh.getSourceChain(iIndependentStarlightSource);
                        if (transmissionChain == null) {
                            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7cStarlight source does not have a transmission chain!"));
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aAmount of nodes this source provides starlight for:\u00c2\u00a7c " + transmissionChain.getEndpointsNodes().size()));
                            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aAmount of normal blocks this source provides starlight for:\u00c2\u00a7c " + transmissionChain.getUncheckedEndpointsBlock().size()));
                            player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aInvolved chunks in this transmission-chain:\u00c2\u00a7c " + transmissionChain.getInvolvedChunks().size()));
                        }
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7cTransmission-Source-Node is missing starlight source!"));
                }
            }
        }
        if (twh != null) {
            Collection<TransmissionChain> chains = twh.getTransmissionChains();
            for (TransmissionChain transmissionChain : chains) {
                if (!transmissionChain.getUncheckedEndpointsBlock().contains(pos)) continue;
                player.func_145747_a((ITextComponent)new TextComponentString("\u00c2\u00a7aFound TransmissionChain transmitting starlight to this block from " + (transmissionChain.getSourceNode() == null ? "null" : transmissionChain.getSourceNode().getPos().toString()) + "!"));
            }
        }
        this.playerAwaitingDebugMode.remove(player.func_110124_au());
        return true;
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        for (UUID plUUID : this.playerAwaitingDebugMode.keySet()) {
            Tuple cd = this.playerAwaitingDebugMode.get(plUUID);
            if ((Integer)(cd = new Tuple((Object)((Integer)cd.func_76341_a() - 1), cd.func_76340_b())).func_76341_a() <= 0) {
                this.playerAwaitingDebugMode.remove(plUUID);
                ((Runnable)cd.func_76340_b()).run();
                continue;
            }
            this.playerAwaitingDebugMode.put(plUUID, (Tuple<Integer, Runnable>)cd);
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Starlight Network Debug Handler";
    }
}

