/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktRequestSextantTarget;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UISextantCache {
    public static final UISextantCache INSTANCE = new UISextantCache();
    private static final long WAIT_TIME_MS = 7500L;
    private static Map<SextantFinder.TargetObject, Long> wait = new HashMap<SextantFinder.TargetObject, Long>();
    private static Map<Tuple<ChunkPos, Integer>, List<CachedSextantResult>> sextantCache = new HashMap<Tuple<ChunkPos, Integer>, List<CachedSextantResult>>();

    private UISextantCache() {
    }

    public static void addTarget(SextantFinder.TargetObject to, BlockPos pos, int dim) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        BlockPos at = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        ChunkPos chAt = new ChunkPos(at);
        Tuple<ChunkPos, Integer> key = new Tuple<ChunkPos, Integer>(chAt, dim);
        List cache = sextantCache.computeIfAbsent(key, t -> new LinkedList());
        cache.removeIf(c -> ((CachedSextantResult)c).target.equals(to));
        cache.add(new CachedSextantResult(to, pos));
    }

    @Nullable
    public static BlockPos queryLocation(BlockPos position, int dim, SextantFinder.TargetObject to) {
        Tuple<ChunkPos, Integer> key = new Tuple<ChunkPos, Integer>(new ChunkPos(position), dim);
        List cache = sextantCache.computeIfAbsent(key, t -> new LinkedList());
        CachedSextantResult result = MiscUtils.iterativeSearch(cache, c -> ((CachedSextantResult)c).target.equals(to));
        if (result != null) {
            return result.destination;
        }
        Long ms = wait.computeIfAbsent(to, t -> 0L);
        if (System.currentTimeMillis() - ms >= 7500L) {
            wait.put(to, System.currentTimeMillis());
            PacketChannel.CHANNEL.sendToServer((IMessage)new PktRequestSextantTarget(to));
        }
        return null;
    }

    public void clearClient() {
        sextantCache.clear();
    }

    static class CachedSextantResult {
        private SextantFinder.TargetObject target;
        private BlockPos destination;

        CachedSextantResult(SextantFinder.TargetObject target, BlockPos destination) {
            this.target = target;
            this.destination = destination;
        }
    }
}

