/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.client.sky.RenderAstralSkybox;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.mappings.ClientConstellationPositionMapping;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class RenderConstellation {
    @SideOnly(value=Side.CLIENT)
    public static void renderConstellation(IConstellation c, ClientConstellationPositionMapping.RenderPosition renderPos, BrightnessFunction brFunc) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        Vector3 renderOffset = renderPos.offset;
        Color rC = c.getTierRenderColor();
        Vector3 dirU = renderPos.incU.clone().subtract(renderOffset).divide(31.0);
        Vector3 dirV = renderPos.incV.clone().subtract(renderOffset).divide(31.0);
        double uLength = dirU.length();
        RenderAstralSkybox.TEX_CONNECTION.bind();
        for (int j = 0; j < 2; ++j) {
            for (StarConnection con : c.getStarConnections()) {
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                float brightness = brFunc.getBrightness();
                GL11.glColor4f((float)((float)rC.getRed() / 255.0f), (float)((float)rC.getGreen() / 255.0f), (float)((float)rC.getBlue() / 255.0f), (float)(brightness < 0.0f ? 0.0f : brightness));
                Vector3 vecA = renderOffset.clone().add(dirU.clone().multiply(con.from.x + 1)).add(dirV.clone().multiply(con.from.y + 1));
                Vector3 vecB = renderOffset.clone().add(dirU.clone().multiply(con.to.x + 1)).add(dirV.clone().multiply(con.to.y + 1));
                Vector3 vecCV = vecB.subtract(vecA);
                Vector3 oPane = dirV.clone().crossProduct(vecCV);
                Vector3 vecAD = oPane.clone().crossProduct(vecCV).normalize().multiply(uLength);
                Vector3 offset00 = vecA.subtract(vecAD.clone().multiply(j == 0 ? 1 : -1));
                Vector3 vecU = vecAD.clone().multiply(j == 0 ? 2 : -2);
                for (int i = 0; i < 4; ++i) {
                    Vector3 pos = offset00.clone().add(vecU.clone().multiply((i + 1 & 2) >> 1)).add(vecCV.clone().multiply((i + 2 & 2) >> 1));
                    vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)((i + 2 & 2) >> 1), (double)((i + 3 & 2) >> 1)).func_181675_d();
                }
                tessellator.func_78381_a();
            }
        }
        RenderAstralSkybox.TEX_STAR_1.bind();
        for (StarLocation star : c.getStars()) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float brightness = brFunc.getBrightness();
            GL11.glColor4f((float)((float)rC.getRed() / 255.0f), (float)((float)rC.getGreen() / 255.0f), (float)((float)rC.getBlue() / 255.0f), (float)(brightness < 0.0f ? 0.0f : brightness));
            int x = star.x;
            int y = star.y;
            Vector3 ofStar = renderOffset.clone().add(dirU.clone().multiply(x)).add(dirV.clone().multiply(y));
            for (int i = 0; i < 4; ++i) {
                int u = (i + 1 & 2) >> 1;
                int v = (i + 2 & 2) >> 1;
                Vector3 pos = ofStar.clone().add(dirU.clone().multiply(u << 1)).add(dirV.clone().multiply(v << 1));
                vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)u, (double)v).func_181675_d();
            }
            tessellator.func_78381_a();
        }
    }

    public static void renderConstellationIntoWorldFlat(IConstellation c, Color rC, Vector3 offsetPos, double scale, double lineBreadth, float br) {
        GlStateManager.func_179094_E();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        double s = 0.03225806451612903 * scale;
        GlStateManager.func_179137_b((double)(-15.5 * s), (double)0.0, (double)(-15.5 * s));
        GlStateManager.func_179129_p();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        float fRed = (float)rC.getRed() / 255.0f;
        float fGreen = (float)rC.getGreen() / 255.0f;
        float fBlue = (float)rC.getBlue() / 255.0f;
        RenderAstralSkybox.TEX_CONNECTION.bind();
        vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (StarConnection sc : c.getStarConnections()) {
            float brightness = br;
            float fAlpha = (brightness = (float)((double)brightness * 0.8)) < 0.0f ? 0.0f : brightness;
            offsetPos.addY(0.001);
            Vector3 offset = offsetPos.clone().addX((double)sc.from.x * s).addZ((double)sc.from.y * s);
            Vector3 dirU = new Vector3(sc.to.x, 0, sc.to.y).subtract(sc.from.x, 0.0, sc.from.y).multiply(s);
            Vector3 dirV = dirU.clone().crossProduct(new Vector3(0, 1, 0)).setY(0).normalize().multiply(lineBreadth * s);
            Vector3 offsetRender = offset.subtract(dirV.clone().divide(2.0));
            Vector3 pos = offsetRender.clone().add(dirU.clone().multiply(0)).add(dirV.clone().multiply(1));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(1.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(1)).add(dirV.clone().multiply(1));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(0.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(1)).add(dirV.clone().multiply(0));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(0.0, 1.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(0)).add(dirV.clone().multiply(0));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(1.0, 1.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        }
        tes.func_78381_a();
        RenderAstralSkybox.TEX_STAR_1.bind();
        vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (StarLocation sl : c.getStars()) {
            float fAlpha = br < 0.0f ? 0.0f : br;
            Vector3 offsetRender = offsetPos.clone().add((double)sl.x * s - s, 0.005, (double)sl.y * s - s);
            Vector3 dirU = new Vector3(s * 2.0, 0.0, 0.0);
            Vector3 dirV = new Vector3(0.0, 0.0, s * 2.0);
            Vector3 pos = offsetRender.clone().add(dirU.clone().multiply(0)).add(dirV.clone().multiply(1));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(1.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(1)).add(dirV.clone().multiply(1));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(0.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(1)).add(dirV.clone().multiply(0));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(0.0, 1.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
            pos = offsetRender.clone().add(dirU.clone().multiply(0)).add(dirV.clone().multiply(0));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(1.0, 1.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        }
        tes.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
    }

    public static void renderConstellationIntoWorld(IConstellation c, Color rC, Vector3 offsetPos, double lineBreadth, BrightnessFunction func) {
        GL11.glPushMatrix();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        Vector3 dirV = new Vector3(0, 0, 1);
        Vector3 dirU = new Vector3(1, 0, 0);
        RenderAstralSkybox.TEX_CONNECTION.bind();
        for (int j = 0; j < 2; ++j) {
            for (StarConnection con : c.getStarConnections()) {
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                float brightness = func.getBrightness();
                GL11.glColor4f((float)((float)rC.getRed() / 255.0f), (float)((float)rC.getGreen() / 255.0f), (float)((float)rC.getBlue() / 255.0f), (float)(brightness < 0.0f ? 0.0f : brightness));
                Vector3 vecA = offsetPos.clone().add(dirU.clone().multiply(con.from.x + 1)).add(dirV.clone().multiply(con.from.y + 1));
                Vector3 vecB = offsetPos.clone().add(dirU.clone().multiply(con.to.x + 1)).add(dirV.clone().multiply(con.to.y + 1));
                Vector3 vecCV = vecB.subtract(vecA);
                Vector3 oPane = dirV.clone().crossProduct(vecCV);
                Vector3 vecAD = oPane.clone().crossProduct(vecCV).normalize().multiply(lineBreadth);
                Vector3 offset00 = vecA.subtract(vecAD.clone().multiply(j == 0 ? 1 : -1));
                Vector3 vecU = vecAD.clone().multiply(j == 0 ? 2 : -2);
                for (int i = 0; i < 4; ++i) {
                    Vector3 pos = offset00.clone().add(vecU.clone().multiply((i + 1 & 2) >> 1)).add(vecCV.clone().multiply((i + 2 & 2) >> 1));
                    vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)((i + 2 & 2) >> 1), (double)((i + 3 & 2) >> 1)).func_181675_d();
                }
                tes.func_78381_a();
            }
        }
        RenderAstralSkybox.TEX_STAR_1.bind();
        for (StarLocation star : c.getStars()) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float brightness = func.getBrightness();
            GL11.glColor4f((float)((float)rC.getRed() / 255.0f), (float)((float)rC.getGreen() / 255.0f), (float)((float)rC.getBlue() / 255.0f), (float)(brightness < 0.0f ? 0.0f : brightness));
            int x = star.x;
            int y = star.y;
            Vector3 ofStar = offsetPos.clone().add(dirU.clone().multiply(x)).add(dirV.clone().multiply(y));
            for (int i = 0; i < 4; ++i) {
                int u = (i + 1 & 2) >> 1;
                int v = (i + 2 & 2) >> 1;
                Vector3 pos = ofStar.clone().add(dirU.clone().multiply(u << 1)).add(dirV.clone().multiply(v << 1));
                vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)u, (double)v).func_181675_d();
            }
            tes.func_78381_a();
        }
        GL11.glPopMatrix();
    }

    public static Map<StarLocation, Rectangle> renderConstellationIntoGUI(IConstellation c, int offsetX, int offsetY, float zLevel, int width, int height, double linebreadth, BrightnessFunction func, boolean isKnown, boolean applyStarBrightness) {
        return RenderConstellation.renderConstellationIntoGUI(c.getTierRenderColor(), c, offsetX, offsetY, zLevel, width, height, linebreadth, func, isKnown, applyStarBrightness);
    }

    public static Map<StarLocation, Rectangle> renderConstellationIntoGUI(Color col, IConstellation c, int offsetX, int offsetY, float zLevel, int width, int height, double linebreadth, BrightnessFunction func, boolean isKnown, boolean applyStarBrightness) {
        float brightness;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        double ulength = (double)width / 31.0;
        double vlength = (double)height / 31.0;
        Vector3 offsetVec = new Vector3((float)offsetX, (float)offsetY, zLevel);
        RenderAstralSkybox.TEX_CONNECTION.bind();
        if (isKnown) {
            for (int j = 0; j < 2; ++j) {
                for (StarConnection sc : c.getStarConnections()) {
                    brightness = func.getBrightness();
                    if (applyStarBrightness) {
                        float starBr = Minecraft.func_71410_x().field_71441_e.func_72880_h(1.0f);
                        if (starBr <= 0.23f) continue;
                        brightness *= starBr * 2.0f;
                    }
                    vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    GL11.glColor4f((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)(brightness < 0.0f ? 0.0f : brightness));
                    Vector3 fromStar = new Vector3(offsetVec.getX() + (double)sc.from.x * ulength, offsetVec.getY() + (double)sc.from.y * vlength, offsetVec.getZ());
                    Vector3 toStar = new Vector3(offsetVec.getX() + (double)sc.to.x * ulength, offsetVec.getY() + (double)sc.to.y * vlength, offsetVec.getZ());
                    Vector3 dir = toStar.clone().subtract(fromStar);
                    Vector3 degLot = dir.clone().crossProduct(new Vector3(0, 0, 1)).normalize().multiply(linebreadth);
                    Vector3 vec00 = fromStar.clone().add(degLot);
                    Vector3 vecV = degLot.clone().multiply(-2);
                    for (int i = 0; i < 4; ++i) {
                        int u = (i + 1 & 2) >> 1;
                        int v = (i + 2 & 2) >> 1;
                        Vector3 pos = vec00.clone().add(dir.clone().multiply(u)).add(vecV.clone().multiply(v));
                        vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)u, (double)v).func_181675_d();
                    }
                    tes.func_78381_a();
                }
            }
        }
        HashMap<StarLocation, Rectangle> starRectangles = new HashMap<StarLocation, Rectangle>();
        RenderAstralSkybox.TEX_STAR_1.bind();
        for (StarLocation sl : c.getStars()) {
            brightness = func.getBrightness();
            if (applyStarBrightness) {
                float starBr = Minecraft.func_71410_x().field_71441_e.func_72880_h(1.0f);
                if (starBr <= 0.23f) continue;
                brightness *= starBr * 2.0f;
            }
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            if (isKnown) {
                GL11.glColor4f((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)brightness);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)(brightness < 0.0f ? 0.0f : brightness));
            }
            int starX = sl.x;
            int starY = sl.y;
            Vector3 starVec = offsetVec.clone().addX((double)starX * ulength - ulength).addY((double)starY * vlength - vlength);
            Point upperLeft = new Point(starVec.getBlockX(), starVec.getBlockY());
            for (int i = 0; i < 4; ++i) {
                int u = (i + 1 & 2) >> 1;
                int v = (i + 2 & 2) >> 1;
                Vector3 pos = starVec.clone().addX(ulength * (double)u * 2.0).addY(vlength * (double)v * 2.0);
                vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)u, (double)v).func_181675_d();
            }
            starRectangles.put(sl, new Rectangle(upperLeft.x, upperLeft.y, (int)(ulength * 2.0), (int)(vlength * 2.0)));
            tes.func_78381_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return starRectangles;
    }

    public static float stdFlicker(long wtime, float partialTicks, int divisor) {
        return RenderConstellation.flickerSin(wtime, partialTicks, divisor, 2.0f, 0.5f);
    }

    public static float conSFlicker(long wtime, float partialTicks, int divisor) {
        return RenderConstellation.flickerSin(wtime, partialTicks, divisor, 4.0f, 0.575f);
    }

    public static float conCFlicker(long wtime, float partialTicks, int divisor) {
        return RenderConstellation.flickerSin(wtime, partialTicks, divisor, 4.0f, 0.375f);
    }

    public static float flickerSin(long wtime, float partialTicks, int divisor, float div, float move) {
        double rad = ((double)wtime + (double)partialTicks) / (double)divisor;
        float sin = MathHelper.func_76126_a((float)((float)rad));
        return sin / div + move;
    }

    public static abstract class BrightnessFunction {
        public abstract float getBrightness();
    }
}

