/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import hellfirepvp.astralsorcery.client.gui.base.GuiWHScreen;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.MoonPhaseRenderHelper;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import java.awt.Color;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class GuiConstellationPaper
extends GuiWHScreen {
    private static final BindableResource textureScroll = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiconpaper");
    private final IConstellation constellation;
    private List<MoonPhase> phases = new LinkedList<MoonPhase>();

    public GuiConstellationPaper(IConstellation c) {
        super(300, 250);
        this.constellation = c;
        this.testPhases();
    }

    private void testPhases() {
        Collections.addAll(this.phases, MoonPhase.values());
    }

    public void func_146281_b() {
        SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        this.drawScroll();
        this.drawHeader();
        this.drawConstellation(partialTicks);
        this.drawPhaseInformation();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void drawHeader() {
        String locName = I18n.func_135052_a((String)this.constellation.getUnlocalizedName(), (Object[])new Object[0]).toUpperCase();
        TextureHelper.refreshTextureBindState();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        double length = (double)fr.func_78256_a(locName) * 1.8;
        double offsetLeft = (double)(this.field_146294_l / 2) - length / 2.0;
        int offsetTop = this.guiTop + 31;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetLeft + 15.0), (double)offsetTop, (double)0.0);
        GL11.glScaled((double)1.8, (double)1.8, (double)1.8);
        fr.func_175065_a(locName, 0.0f, 0.0f, -1437774515, false);
        GL11.glPopMatrix();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawConstellation(float parTicks) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderConstellation.renderConstellationIntoGUI(new Color(0.4f, 0.4f, 0.4f, 0.8f), this.constellation, this.field_146294_l / 2 - 55, this.guiTop + 84, this.field_73735_i, 110, 110, 2.0, new RenderConstellation.BrightnessFunction(){

            @Override
            public float getBrightness() {
                return 0.5f;
            }
        }, true, false);
        GL11.glDisable((int)3042);
    }

    private void drawPhaseInformation() {
        GlStateManager.func_179147_l();
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        Blending.DEFAULT.applyStateManager();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.constellation instanceof IConstellationSpecialShowup) {
            double scale = 1.8;
            TextureHelper.refreshTextureBindState();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            double length = (double)fr.func_78256_a("? ? ?") * scale;
            double offsetLeft = (double)(this.field_146294_l / 2) - length / 2.0;
            int offsetTop = this.guiTop + 207;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(offsetLeft + 10.0), (double)offsetTop, (double)0.0);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            fr.func_175065_a("? ? ?", 0.0f, 0.0f, -1437774515, false);
            GL11.glPopMatrix();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
        } else {
            if (this.phases.isEmpty()) {
                this.testPhases();
                if (this.phases.isEmpty()) {
                    return;
                }
            }
            int size = 15;
            int offsetX = this.field_146294_l / 2 + 5 - this.phases.size() * (size + 2) / 2;
            int offsetY = this.guiTop + 206;
            for (int i = 0; i < this.phases.size(); ++i) {
                MoonPhase ph = this.phases.get(i);
                MoonPhaseRenderHelper.getMoonPhaseTexture(ph).bind();
                this.drawRect(offsetX + i * (size + 2), offsetY, size, size);
            }
        }
    }

    private void drawScroll() {
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        this.drawWHRect(textureScroll);
        GL11.glDisable((int)3042);
    }
}

