/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.util.Counter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientScheduler
implements ITickHandler {
    private static long clientTick = 0L;
    private static final Object lock = new Object();
    private boolean inTick = false;
    private Map<Runnable, Counter> queuedRunnables = new HashMap<Runnable, Counter>();
    private Map<Runnable, Integer> waitingRunnables = new HashMap<Runnable, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        ++clientTick;
        this.inTick = true;
        Object object = lock;
        synchronized (object) {
            this.inTick = true;
            Iterator<Runnable> iterator = this.queuedRunnables.keySet().iterator();
            while (iterator.hasNext()) {
                Runnable r = iterator.next();
                Counter delay = this.queuedRunnables.get(r);
                delay.decrement();
                if (delay.value > 0) continue;
                r.run();
                iterator.remove();
            }
            this.inTick = false;
            for (Map.Entry<Runnable, Integer> waiting : this.waitingRunnables.entrySet()) {
                this.queuedRunnables.put(waiting.getKey(), new Counter(waiting.getValue()));
            }
        }
        this.waitingRunnables.clear();
    }

    public static long getClientTick() {
        return clientTick;
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.CLIENT);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Client Scheduler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRunnable(Runnable r, int tickDelay) {
        Object object = lock;
        synchronized (object) {
            if (this.inTick) {
                this.waitingRunnables.put(r, tickDelay);
            } else {
                this.queuedRunnables.put(r, new Counter(tickDelay));
            }
        }
    }
}

