/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final amu world;
    private final et pos;
    private final awt state;

    public BlockEvent(amu world, et pos, awt state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    public amu getWorld() {
        return this.world;
    }

    public et getPos() {
        return this.pos;
    }

    public awt getState() {
        return this.state;
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final ass.a size;

        public PortalSpawnEvent(amu world, et pos, awt state, ass.a size) {
            super(world, pos, state);
            this.size = size;
        }

        public ass.a getPortalSize() {
            return this.size;
        }
    }

    public static class CropGrowEvent
    extends BlockEvent {
        public CropGrowEvent(amu world, et pos, awt state) {
            super(world, pos, state);
        }

        public static class Post
        extends CropGrowEvent {
            private final awt originalState;

            public Post(amu world, et pos, awt original, awt state) {
                super(world, pos, state);
                this.originalState = original;
            }

            public awt getOriginalState() {
                return this.originalState;
            }
        }

        @Event.HasResult
        public static class Pre
        extends CropGrowEvent {
            public Pre(amu world, et pos, awt state) {
                super(world, pos, state);
            }
        }
    }

    @Event.HasResult
    public static class CreateFluidSourceEvent
    extends BlockEvent {
        public CreateFluidSourceEvent(amu world, et pos, awt state) {
            super(world, pos, state);
        }
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<fa> notifiedSides;
        private final boolean forceRedstoneUpdate;

        public NeighborNotifyEvent(amu world, et pos, awt state, EnumSet<fa> notifiedSides, boolean forceRedstoneUpdate) {
            super(world, pos, state);
            this.notifiedSides = notifiedSides;
            this.forceRedstoneUpdate = forceRedstoneUpdate;
        }

        public EnumSet<fa> getNotifiedSides() {
            return this.notifiedSides;
        }

        public boolean getForceRedstoneUpdate() {
            return this.forceRedstoneUpdate;
        }
    }

    @Cancelable
    public static class MultiPlaceEvent
    extends PlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public MultiPlaceEvent(@Nonnull List<BlockSnapshot> blockSnapshots, @Nonnull awt placedAgainst, @Nonnull aed player, @Nonnull ub hand) {
            super(blockSnapshots.get(0), placedAgainst, player, hand);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created MultiPlaceEvent - [PlacedAgainst: %s ][ItemInHand: %s ][Player: %s ]\n", placedAgainst, player.b(hand), player);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class PlaceEvent
    extends BlockEvent {
        private final aed player;
        private final BlockSnapshot blockSnapshot;
        private final awt placedBlock;
        private final awt placedAgainst;
        private final ub hand;

        public PlaceEvent(@Nonnull BlockSnapshot blockSnapshot, @Nonnull awt placedAgainst, @Nonnull aed player, @Nonnull ub hand) {
            super(blockSnapshot.getWorld(), blockSnapshot.getPos(), blockSnapshot.getCurrentBlock());
            this.player = player;
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            this.hand = hand;
            if (DEBUG) {
                System.out.printf("Created PlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][ItemStack: %s ][Player: %s ][Hand: %s]\n", this.getPlacedBlock(), placedAgainst, player.b(hand), player, hand);
            }
        }

        public aed getPlayer() {
            return this.player;
        }

        @Nonnull
        @Deprecated
        public aip getItemInHand() {
            return this.player.b(this.hand);
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public awt getPlacedBlock() {
            return this.placedBlock;
        }

        public awt getPlacedAgainst() {
            return this.placedAgainst;
        }

        public ub getHand() {
            return this.hand;
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final aed player;
        private int exp;

        public BreakEvent(amu world, et pos, awt state, aed player) {
            super(world, pos, state);
            this.player = player;
            if (state == null || !ForgeHooks.canHarvestBlock(state.u(), player, (amy)world, pos) || state.u().canSilkHarvest(world, pos, world.o(pos), player) && alm.a((alk)alo.t, (aip)player.co()) > 0) {
                this.exp = 0;
            } else {
                int bonusLevel = alm.a((alk)alo.v, (aip)player.co());
                this.exp = state.u().getExpDrop(state, (amy)world, pos, bonusLevel);
            }
        }

        public aed getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        private final int fortuneLevel;
        private final List<aip> drops;
        private final boolean isSilkTouching;
        private float dropChance;
        private final aed harvester;

        public HarvestDropsEvent(amu world, et pos, awt state, int fortuneLevel, float dropChance, List<aip> drops, aed harvester, boolean isSilkTouching) {
            super(world, pos, state);
            this.fortuneLevel = fortuneLevel;
            this.setDropChance(dropChance);
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }

        public int getFortuneLevel() {
            return this.fortuneLevel;
        }

        public List<aip> getDrops() {
            return this.drops;
        }

        public boolean isSilkTouching() {
            return this.isSilkTouching;
        }

        public float getDropChance() {
            return this.dropChance;
        }

        public void setDropChance(float dropChance) {
            this.dropChance = dropChance;
        }

        public aed getHarvester() {
            return this.harvester;
        }
    }
}

