/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.apache.commons.lang3.text.WordUtils;

public class MiscUtil {
    public static final int WRAP_LENGTH = 45;

    public static void appendMultiline(List<String> result, String key, Object ... args) {
        String raw = MiscUtil.translate(key, args);
        int n = 0;
        for (String s : raw.split("\\\\n")) {
            for (String s1 : WordUtils.wrap((String)s, (int)45).split("\\\n")) {
                result.add((n++ > 0 ? "\u00a77" : "") + s1);
            }
        }
    }

    public static String[] splitLong(String key, int len, Object ... args) {
        return WordUtils.wrap((String)I18n.func_135052_a((String)key, (Object[])args), (int)len, (String)"=CUT", (boolean)false, (String)"\\n").split("=CUT");
    }

    public static List<String> wrapString(String text) {
        return MiscUtil.wrapString(text, 45);
    }

    public static List<String> wrapString(String text, int maxCharPerLine) {
        StringTokenizer tok = new StringTokenizer(text, " ");
        StringBuilder output = new StringBuilder(text.length());
        ArrayList<String> textList = new ArrayList<String>();
        String color = "";
        int lineLen = 0;
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (word.contains("\u00a7")) {
                for (int i = 0; i < word.length() - 1; ++i) {
                    if (!word.substring(i, i + 2).contains("\u00a7")) continue;
                    color = word.substring(i, i + 2);
                }
                lineLen -= 2;
            }
            if (lineLen + word.length() > maxCharPerLine || word.contains("\\n")) {
                word = word.replace("\\n", "");
                textList.add(output.toString());
                output.delete(0, output.length());
                output.append(color);
                lineLen = 0;
            } else if (lineLen > 0) {
                output.append(" ");
                ++lineLen;
            }
            output.append(word);
            lineLen += word.length();
        }
        textList.add(output.toString());
        return textList;
    }

    public static String locToString(World world, BlockPos pos) {
        return MiscUtil.locToString(world.field_73011_w.getDimension(), pos);
    }

    public static String locToString(int dim, BlockPos pos) {
        return String.format("DIM:%d X:%d Y:%d Z:%d", dim, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static String translate(String key, Object ... args) {
        return new TextComponentTranslation(key, args).func_150260_c();
    }

    public static ResourceLocation RL(String name) {
        return new ResourceLocation("modularrouters", name);
    }

    public static TileEntity getTileEntitySafely(IBlockAccess world, BlockPos pos) {
        return world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
    }

    public static int getYawFromFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 180;
            }
            case SOUTH: {
                return 0;
            }
            case WEST: {
                return 90;
            }
            case EAST: {
                return -90;
            }
        }
        return 0;
    }

    public static String getFluidName(ItemStack stack) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        return f == null ? stack.func_82833_r() : f.getFluid().getLocalizedName(f);
    }
}

