/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.util.FakePlayerManager;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.IItemHandler;

public class BlockUtil {
    private static final String[] REED_ITEM = new String[]{"block", "field_150935_a", "a"};

    private static IBlockState getPlaceableState(EntityPlayer fakePlayer, ItemStack stack, World world, BlockPos pos, EnumFacing facing, EnumFacing horizFacing) {
        try {
            Item item = stack.func_77973_b();
            IBlockState res = null;
            if (item instanceof ItemBlock) {
                float hitX = (float)(fakePlayer.field_70165_t - (double)pos.func_177958_n());
                float hitY = (float)(fakePlayer.field_70163_u - (double)pos.func_177956_o());
                float hitZ = (float)(fakePlayer.field_70161_v - (double)pos.func_177952_p());
                int meta = item.func_77647_b(stack.func_77952_i());
                res = ((ItemBlock)item).func_179223_d().getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)fakePlayer, EnumHand.MAIN_HAND);
            } else if (item instanceof ItemBlockSpecial) {
                res = ((Block)ReflectionHelper.getPrivateValue(ItemBlockSpecial.class, (Object)((ItemBlockSpecial)item), (String[])REED_ITEM)).func_176223_P();
            } else if (item instanceof ItemRedstone) {
                res = Blocks.field_150488_af.func_176223_P();
            } else if (item instanceof ItemDye && EnumDyeColor.func_176766_a((int)stack.func_77960_j()) == EnumDyeColor.BROWN) {
                res = BlockUtil.getCocoaBeanState(fakePlayer, world, pos);
                if (res != null) {
                    facing = (EnumFacing)res.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                }
            } else if (item instanceof IPlantable) {
                IBlockState state = ((IPlantable)item).getPlant((IBlockAccess)world, pos);
                res = state.func_177230_c() instanceof BlockCrops && ((BlockCrops)state.func_177230_c()).func_180671_f(world, pos, state) ? state : null;
            } else if (item instanceof ItemSkull) {
                res = Blocks.field_150465_bP.func_176223_P();
                BlockPos pos2 = pos.func_177977_b();
                if (world.func_180495_p(pos2).isSideSolid((IBlockAccess)world, pos2, EnumFacing.UP)) {
                    facing = EnumFacing.UP;
                }
            }
            if (res != null) {
                if (res.func_177228_b().containsKey((Object)BlockDirectional.field_176387_N)) {
                    res = res.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)facing);
                } else if (res.func_177228_b().containsKey((Object)BlockHorizontal.field_185512_D)) {
                    res = res.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)(facing.func_176736_b() >= 0 ? facing : horizFacing));
                }
            }
            return res;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static IBlockState getCocoaBeanState(EntityPlayer fakePlayer, World world, BlockPos pos) {
        for (EnumFacing f : EnumFacing.field_176754_o) {
            IBlockState state = world.func_180495_p(pos.func_177972_a(f));
            if (state.func_177230_c() != Blocks.field_150364_r || state.func_177229_b((IProperty)BlockOldLog.field_176301_b) != BlockPlanks.EnumType.JUNGLE) continue;
            float hitX = (float)(fakePlayer.field_70165_t - (double)pos.func_177958_n());
            float hitY = (float)(fakePlayer.field_70163_u - (double)pos.func_177956_o());
            float hitZ = (float)(fakePlayer.field_70161_v - (double)pos.func_177952_p());
            fakePlayer.field_70177_z = BlockUtil.getYawFromFacing(f);
            return Blocks.field_150375_by.getStateForPlacement(world, pos, f.func_176734_d(), hitX, hitY, hitZ, 0, (EntityLivingBase)fakePlayer, EnumHand.MAIN_HAND);
        }
        return null;
    }

    private static float getYawFromFacing(EnumFacing facing) {
        switch (facing) {
            case WEST: {
                return 90.0f;
            }
            case NORTH: {
                return 180.0f;
            }
            case EAST: {
                return 270.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    private static void handleSkullPlacement(World worldIn, BlockPos pos, ItemStack stack, EnumFacing facing) {
        TileEntity tileentity;
        int i = 0;
        if (worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockDirectional.field_176387_N) == EnumFacing.UP) {
            i = MathHelper.func_76128_c((double)((double)(facing.func_185119_l() * 16.0f / 360.0f) + 0.5)) & 0xF;
        }
        if ((tileentity = worldIn.func_175625_s(pos)) instanceof TileEntitySkull) {
            TileEntitySkull tileentityskull = (TileEntitySkull)tileentity;
            if (stack.func_77960_j() == 3) {
                GameProfile gameprofile = null;
                if (stack.func_77942_o()) {
                    NBTTagCompound nbttagcompound = stack.func_77978_p();
                    if (nbttagcompound.func_150297_b("SkullOwner", 10)) {
                        gameprofile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("SkullOwner"));
                    } else if (nbttagcompound.func_150297_b("SkullOwner", 8) && !nbttagcompound.func_74779_i("SkullOwner").isEmpty()) {
                        gameprofile = new GameProfile(null, nbttagcompound.func_74779_i("SkullOwner"));
                    }
                }
                tileentityskull.func_152106_a(gameprofile);
            } else {
                tileentityskull.func_152107_a(stack.func_77960_j());
            }
            tileentityskull.func_145903_a(i);
            Blocks.field_150465_bP.func_180679_a(worldIn, pos, tileentityskull);
        }
    }

    public static IBlockState tryPlaceAsBlock(ItemStack toPlace, World world, BlockPos pos, EnumFacing facing, EnumFacing horizFacing) {
        IBlockState currentState = world.func_180495_p(pos);
        if (!currentState.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            return null;
        }
        FakePlayerManager.RouterFakePlayer fakePlayer = FakePlayerManager.getFakePlayer((WorldServer)world, pos);
        if (fakePlayer == null) {
            return null;
        }
        fakePlayer.field_70177_z = BlockUtil.getYawFromFacing(facing);
        IBlockState newState = BlockUtil.getPlaceableState((EntityPlayer)fakePlayer, toPlace, world, pos, facing, horizFacing);
        if (newState != null && newState.func_177230_c().func_176196_c(world, pos)) {
            BlockSnapshot snap = new BlockSnapshot(world, pos, newState);
            fakePlayer.func_184611_a(EnumHand.MAIN_HAND, toPlace);
            BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(snap, Blocks.field_150350_a.func_176223_P(), (EntityPlayer)fakePlayer, EnumHand.MAIN_HAND);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled() && world.func_180501_a(pos, newState, 3)) {
                fakePlayer.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                ItemBlock.func_179224_a((World)world, (EntityPlayer)fakePlayer, (BlockPos)pos, (ItemStack)toPlace);
                newState.func_177230_c().func_180633_a(world, pos, newState, (EntityLivingBase)fakePlayer, toPlace);
                if (newState.func_177230_c() == Blocks.field_150465_bP) {
                    BlockUtil.handleSkullPlacement(world, pos, toPlace, facing);
                }
                return newState;
            }
        }
        return null;
    }

    public static BreakResult tryBreakBlock(World world, BlockPos pos, Filter filter, boolean silkTouch, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || state.func_185887_b(world, pos) < 0.0f || block instanceof BlockLiquid) {
            return BreakResult.NOT_BROKEN;
        }
        FakePlayerManager.RouterFakePlayer fakePlayer = FakePlayerManager.getFakePlayer((WorldServer)world, pos);
        List<ItemStack> allDrops = BlockUtil.getDrops(world, pos, (EntityPlayer)fakePlayer, silkTouch, fortune);
        Map<Boolean, List<ItemStack>> groups = allDrops.stream().collect(Collectors.partitioningBy(filter));
        if (allDrops.isEmpty() || !groups.get(true).isEmpty()) {
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)fakePlayer);
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (!breakEvent.isCanceled()) {
                if (block instanceof BlockShulkerBox) {
                    ItemStack stack = BlockUtil.specialShulkerBoxHandling(world, pos);
                    groups = new HashMap<Boolean, List<ItemStack>>();
                    groups.put(true, Lists.newArrayList((Object[])new ItemStack[]{stack}));
                }
                world.func_175698_g(pos);
                return new BreakResult(true, groups);
            }
        }
        return BreakResult.NOT_BROKEN;
    }

    private static ItemStack specialShulkerBoxHandling(World world, BlockPos pos) {
        TileEntityShulkerBox tesb;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityShulkerBox && !(tesb = (TileEntityShulkerBox)te).func_190590_r() && tesb.func_190582_F()) {
            ItemStack itemstack = new ItemStack(Item.func_150898_a((Block)world.func_180495_p(pos).func_177230_c()));
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound.func_74782_a("BlockEntityTag", (NBTBase)tesb.func_190580_f(nbttagcompound1));
            itemstack.func_77982_d(nbttagcompound);
            if (tesb.func_145818_k_()) {
                itemstack.func_151001_c(tesb.func_70005_c_());
                tesb.func_190575_a("");
            }
            tesb.func_174888_l();
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    private static List<ItemStack> getDrops(World world, BlockPos pos, EntityPlayer player, boolean silkTouch, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (silkTouch) {
            Item item = Item.func_150898_a((Block)block);
            if (item == Items.field_190931_a) {
                return Collections.emptyList();
            }
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(item, 1, block.func_176201_c(state))});
        }
        NonNullList drops = NonNullList.func_191196_a();
        block.getDrops(drops, (IBlockAccess)world, pos, state, fortune);
        float dropChance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
        return drops.stream().filter(s -> world.field_73012_v.nextFloat() <= dropChance).collect(Collectors.toList());
    }

    public static String getBlockName(World w, BlockPos pos) {
        if (w == null) {
            return null;
        }
        IBlockState state = w.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)w, pos)) {
            return "";
        }
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), 1, state.func_177230_c().func_180651_a(state));
        if (!stack.func_190926_b()) {
            return stack.func_82833_r();
        }
        return state.func_177230_c().func_149732_F();
    }

    public static class BreakResult {
        static final BreakResult NOT_BROKEN = new BreakResult(false, Collections.emptyMap());
        private final boolean blockBroken;
        private final Map<Boolean, List<ItemStack>> drops;

        BreakResult(boolean blockBroken, Map<Boolean, List<ItemStack>> drops) {
            this.blockBroken = blockBroken;
            this.drops = drops;
        }

        public boolean isBlockBroken() {
            return this.blockBroken;
        }

        List<ItemStack> getFilteredDrops(boolean passed) {
            return this.drops.getOrDefault(passed, Collections.emptyList());
        }

        public void processDrops(World world, BlockPos pos, IItemHandler handler) {
            for (ItemStack drop : this.getFilteredDrops(true)) {
                ItemStack excess = handler.insertItem(0, drop, false);
                if (excess.func_190926_b()) continue;
                InventoryUtils.dropItems(world, pos, excess);
            }
            for (ItemStack drop : this.getFilteredDrops(false)) {
                InventoryUtils.dropItems(world, pos, drop);
            }
        }
    }
}

