/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.awt.Color;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.ParticleBeamMessage;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;

public class CompiledSenderModule1
extends CompiledModule {
    private static final Color particleColor = Color.ORANGE;

    public CompiledSenderModule1(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
    }

    @Override
    public boolean execute(TileEntityItemRouter router) {
        PositionedItemHandler target;
        IItemHandler buffer = router.getBuffer();
        ItemStack bufferStack = buffer.getStackInSlot(0);
        if (this.getFilter().test(bufferStack) && (target = this.findTargetInventory(router)) != null) {
            int sent;
            int nToSend = this.getItemsPerTick(router);
            if (this.getRegulationAmount() > 0) {
                int existing = InventoryUtils.countItems(bufferStack, target.handler, this.getRegulationAmount(), !this.getFilter().getFlags().isIgnoreMeta());
                if ((nToSend = Math.min(nToSend, this.getRegulationAmount() - existing)) <= 0) {
                    return false;
                }
            }
            if ((sent = InventoryUtils.transferItems(buffer, target.handler, 0, nToSend)) > 0) {
                if (ConfigHandler.module.senderParticles) {
                    this.playParticles(router, target.pos);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected void playParticles(TileEntityItemRouter router, BlockPos targetPos) {
        if (router.getUpgradeCount(ItemUpgrade.UpgradeType.MUFFLER) < 2) {
            Vec3d vec1 = new Vec3d((Vec3i)router.func_174877_v()).func_72441_c(0.5, 0.5, 0.5);
            Vec3d vec2 = new Vec3d((Vec3i)targetPos).func_72441_c(0.5, 0.5, 0.5);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(router.func_145831_w().field_73011_w.getDimension(), vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, 32.0);
            ModularRouters.network.sendToAllAround((IMessage)new ParticleBeamMessage(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, particleColor, 0.3f), point);
        }
    }

    protected PositionedItemHandler findTargetInventory(TileEntityItemRouter router) {
        ModuleTarget target = this.getActualTarget(router);
        if (target != null) {
            IItemHandler handler = InventoryUtils.getInventory((World)DimensionManager.getWorld((int)target.dimId), target.pos, target.face);
            return handler == null ? null : new PositionedItemHandler(target.pos, handler);
        }
        return null;
    }

    @Override
    public ModuleTarget getActualTarget(TileEntityItemRouter router) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getTarget().pos);
        EnumFacing face = this.getTarget().face;
        World world = router.func_145831_w();
        for (int i = 1; i <= this.getRange(); ++i) {
            if (world.func_175625_s((BlockPos)pos) != null) {
                return new ModuleTarget(world.field_73011_w.getDimension(), pos.func_185334_h(), face, BlockUtil.getBlockName(world, (BlockPos)pos));
            }
            if (!this.isPassable(world, (BlockPos)pos, face)) {
                return null;
            }
            pos.func_189536_c(this.getFacing());
        }
        return null;
    }

    private boolean isPassable(World w, BlockPos pos, EnumFacing face) {
        IBlockState state = w.func_180495_p(pos);
        return state.func_193401_d((IBlockAccess)w, pos, face) != BlockFaceShape.SOLID || !state.func_185914_p();
    }

    static class PositionedItemHandler {
        private final BlockPos pos;
        private final IItemHandler handler;

        PositionedItemHandler(BlockPos pos, IItemHandler handler) {
            this.pos = pos;
            this.handler = handler;
        }
    }
}

