/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Comparator;
import java.util.List;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.FakePlayerManager;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CompiledActivatorModule
extends CompiledModule {
    public static final String NBT_ACTION_TYPE = "ActionType";
    public static final String NBT_LOOK_DIRECTION = "LookDirection";
    public static final String NBT_SNEAKING = "Sneaking";
    private final ActionType actionType;
    private final LookDirection lookDirection;
    private final boolean sneaking;

    public CompiledActivatorModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            this.actionType = ActionType.values()[compound.func_74762_e(NBT_ACTION_TYPE)];
            this.lookDirection = LookDirection.values()[compound.func_74762_e(NBT_LOOK_DIRECTION)];
            this.sneaking = compound.func_74767_n(NBT_SNEAKING);
        } else {
            this.actionType = ActionType.ACTIVATE_BLOCK;
            this.lookDirection = LookDirection.LEVEL;
            this.sneaking = false;
        }
    }

    @Override
    public boolean execute(TileEntityItemRouter router) {
        BlockPos pos;
        World world = router.func_145831_w();
        FakePlayerManager.RouterFakePlayer fakePlayer = FakePlayerManager.getFakePlayer((WorldServer)world, pos = router.func_174877_v());
        if (fakePlayer == null) {
            return false;
        }
        fakePlayer.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5 - (double)fakePlayer.eyeHeight, (double)pos.func_177952_p() + 0.5);
        fakePlayer.field_70125_A = this.getFacing().func_96559_d() * -90;
        fakePlayer.field_70177_z = MiscUtil.getYawFromFacing(this.getFacing());
        fakePlayer.func_70095_a(this.sneaking);
        ItemStack stack = router.getBufferItemStack();
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, stack);
        float hitX = (float)(fakePlayer.field_70165_t - (double)pos.func_177958_n());
        float hitY = (float)(fakePlayer.field_70163_u - (double)pos.func_177956_o());
        float hitZ = (float)(fakePlayer.field_70161_v - (double)pos.func_177952_p());
        switch (this.actionType) {
            case ACTIVATE_BLOCK: {
                return this.doActivateBlock(router, world, pos, (EntityPlayer)fakePlayer, hitX, hitY, hitZ);
            }
            case USE_ITEM: {
                return this.doUseItem(router, world, pos, (EntityPlayer)fakePlayer, hitX, hitY, hitZ);
            }
            case USE_ITEM_ON_ENTITY: {
                return this.doUseItemOnEntity(router, fakePlayer);
            }
        }
        return false;
    }

    private boolean doUseItemOnEntity(TileEntityItemRouter router, FakePlayer fakePlayer) {
        Entity entity = this.findNearestEntity(router);
        if (entity == null) {
            return false;
        }
        EnumActionResult result = fakePlayer.func_190775_a(entity, EnumHand.MAIN_HAND);
        if (result == EnumActionResult.SUCCESS) {
            router.setBufferItemStack(fakePlayer.func_184614_ca());
            return true;
        }
        return false;
    }

    private Entity findNearestEntity(TileEntityItemRouter router) {
        EnumFacing face = this.getFacing();
        BlockPos pos = router.func_174877_v();
        AxisAlignedBB box = new AxisAlignedBB(pos.func_177972_a(face)).func_72321_a((double)(face.func_82601_c() * 3), (double)(face.func_96559_d() * 3), (double)(face.func_82599_e() * 3));
        List l = router.func_145831_w().func_72872_a(Entity.class, box);
        if (l.isEmpty()) {
            return null;
        }
        l.sort(Comparator.comparingDouble(o -> o.func_174818_b(pos)));
        return (Entity)l.get(0);
    }

    private boolean doUseItem(TileEntityItemRouter router, World world, BlockPos pos, EntityPlayer fakePlayer, float hitX, float hitY, float hitZ) {
        Block block;
        BlockPos targetPos = pos.func_177972_a(this.getFacing());
        EnumFacing hitFace = this.getHitFace();
        switch (this.lookDirection) {
            case LEVEL: {
                for (int i = 0; i < 4 && world.func_175623_d(targetPos); ++i) {
                    targetPos = targetPos.func_177972_a(this.getFacing());
                }
                break;
            }
            case ABOVE: {
                targetPos = targetPos.func_177984_a();
                break;
            }
            case BELOW: {
                targetPos = targetPos.func_177977_b();
            }
        }
        ItemStack stack = fakePlayer.func_184614_ca();
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)fakePlayer, (EnumHand)EnumHand.MAIN_HAND, (BlockPos)targetPos, (EnumFacing)hitFace, (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)fakePlayer, (double)2.0));
        if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
            return false;
        }
        EnumActionResult ret = stack.onItemUseFirst(fakePlayer, world, targetPos, EnumHand.MAIN_HAND, hitFace, hitX, hitY, hitZ);
        if (ret != EnumActionResult.PASS) {
            return false;
        }
        if (stack.func_190926_b() || fakePlayer.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlock && !fakePlayer.func_189808_dh() && ((block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof BlockCommandBlock || block instanceof BlockStructure)) {
            return false;
        }
        if (event.getUseItem() != Event.Result.DENY) {
            ItemStack copyBeforeUse = stack.func_77946_l();
            EnumActionResult result = stack.func_179546_a(fakePlayer, world, targetPos, EnumHand.MAIN_HAND, hitFace, hitX, hitY, hitZ);
            if (result == EnumActionResult.PASS) {
                ActionResult rightClickResult = stack.func_77973_b().func_77659_a(world, fakePlayer, EnumHand.MAIN_HAND);
                fakePlayer.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)rightClickResult.func_188398_b());
            }
            if (fakePlayer.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)fakePlayer, (ItemStack)copyBeforeUse, (EnumHand)EnumHand.MAIN_HAND);
            }
            router.setBufferItemStack(fakePlayer.func_184614_ca());
            return true;
        }
        return false;
    }

    private boolean doActivateBlock(TileEntityItemRouter router, World world, BlockPos pos, EntityPlayer fakePlayer, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        BlockPos targetPos = this.findBlockToActivate(router);
        if (targetPos == null) {
            return false;
        }
        EnumFacing hitFace = this.getHitFace();
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)fakePlayer, (EnumHand)EnumHand.MAIN_HAND, (BlockPos)targetPos, (EnumFacing)hitFace, (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)fakePlayer, (double)2.0));
        if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
            return false;
        }
        if (event.getUseBlock() != Event.Result.DENY && (iblockstate = world.func_180495_p(targetPos)).func_177230_c().func_180639_a(world, targetPos, iblockstate, fakePlayer, EnumHand.MAIN_HAND, hitFace, hitX, hitY, hitZ)) {
            router.setBufferItemStack(fakePlayer.func_184614_ca());
            return true;
        }
        return false;
    }

    private BlockPos findBlockToActivate(TileEntityItemRouter router) {
        switch (this.lookDirection) {
            case LEVEL: {
                for (int i = 1; i < 5; ++i) {
                    BlockPos pos = router.func_174877_v().func_177967_a(this.getFacing(), i);
                    if (router.func_145831_w().func_175623_d(pos)) continue;
                    return pos;
                }
                break;
            }
            case ABOVE: {
                return router.func_174877_v().func_177972_a(this.getFacing()).func_177984_a();
            }
            case BELOW: {
                return router.func_174877_v().func_177972_a(this.getFacing()).func_177977_b();
            }
        }
        return null;
    }

    private EnumFacing getHitFace() {
        switch (this.lookDirection) {
            case ABOVE: {
                return EnumFacing.DOWN;
            }
            case BELOW: {
                return EnumFacing.UP;
            }
        }
        return this.getFacing().func_176734_d();
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public LookDirection getLookDirection() {
        return this.lookDirection;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public static enum LookDirection {
        LEVEL,
        ABOVE,
        BELOW;

    }

    public static enum ActionType {
        ACTIVATE_BLOCK,
        USE_ITEM,
        USE_ITEM_ON_ENTITY;

    }
}

