/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.logic.compiled.CompiledActivatorModule;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class GuiModuleActivator
extends GuiModule {
    private static final ItemStack BLOCK_STACK = new ItemStack(Blocks.field_150367_z);
    private static final ItemStack ITEM_STACK = new ItemStack((Item)Items.field_151031_f);
    private static final ItemStack ENTITY_STACK = new ItemStack(Items.field_151144_bL, 1, 3);
    private static final int ACTION_BUTTON_ID = 1000;
    private static final int LOOK_DIRECTION_ID = 1001;
    private static final int SNEAK_BUTTON_ID = 1002;
    private CompiledActivatorModule.ActionType actionType;
    private CompiledActivatorModule.LookDirection lookDirection;
    private LookDirectionButton lookDirectionButton;
    private boolean isSneaking;

    public GuiModuleActivator(ContainerModule containerItem, EnumHand hand) {
        this(containerItem, null, -1, hand);
    }

    public GuiModuleActivator(ContainerModule containerItem, BlockPos routerPos, Integer slotIndex, EnumHand hand) {
        super(containerItem, routerPos, slotIndex, hand);
        CompiledActivatorModule cam = new CompiledActivatorModule(null, this.moduleItemStack);
        this.actionType = cam.getActionType();
        this.lookDirection = cam.getLookDirection();
        this.isSneaking = cam.isSneaking();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ItemStack[] stacks = new ItemStack[]{BLOCK_STACK, ITEM_STACK, ENTITY_STACK};
        this.field_146292_n.add(new ActionTypeButton(1000, this.field_147003_i + 167, this.field_147009_r + 20, 16, 16, true, stacks, this.actionType));
        this.field_146292_n.add(new SneakButton(1002, this.field_147003_i + 167, this.field_147009_r + 40, this.isSneaking));
        this.lookDirectionButton = new LookDirectionButton(1001, this.field_147003_i + 167, this.field_147009_r + 60, 16, 16, this.lookDirection);
        this.field_146292_n.add(this.lookDirectionButton);
        this.lookDirectionButton.field_146125_m = this.actionType != CompiledActivatorModule.ActionType.USE_ITEM_ON_ENTITY;
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 130, this.field_147009_r + 18, this.field_147003_i + 183, this.field_147009_r + 37, "guiText.popup.activator.action");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 130, this.field_147009_r + 39, this.field_147003_i + 183, this.field_147009_r + 56, "guiText.popup.activator.sneak");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 130, this.field_147009_r + 59, this.field_147003_i + 183, this.field_147009_r + 76, "guiText.popup.activator.look", guiContainer -> this.lookDirectionButton.field_146125_m);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.func_73729_b(this.field_147003_i + 165, this.field_147009_r + 19, GuiModuleActivator.BUTTON_XY.x, GuiModuleActivator.BUTTON_XY.y, 18, 18);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"guiText.tooltip.activator.action", (Object[])new Object[0]), 132, 23, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"guiText.tooltip.activator.sneak", (Object[])new Object[0]), 132, 43, 0x404040);
        if (this.actionType != CompiledActivatorModule.ActionType.USE_ITEM_ON_ENTITY) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"guiText.tooltip.activator.lookDirection", (Object[])new Object[0]), 132, 63, 0x404040);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1000: {
                ActionTypeButton atb = (ActionTypeButton)button;
                this.actionType = (CompiledActivatorModule.ActionType)((Object)atb.cycle(!GuiScreen.func_146272_n()));
                this.sendModuleSettingsToServer();
                break;
            }
            case 1001: {
                LookDirectionButton ldb = (LookDirectionButton)button;
                this.lookDirection = (CompiledActivatorModule.LookDirection)((Object)ldb.cycle(!GuiScreen.func_146272_n()));
                this.sendModuleSettingsToServer();
                break;
            }
            case 1002: {
                SneakButton sb = (SneakButton)button;
                sb.toggle();
                this.isSneaking = sb.isToggled();
                this.sendModuleSettingsToServer();
                break;
            }
            default: {
                super.func_146284_a(button);
            }
        }
        this.lookDirectionButton.field_146125_m = this.actionType != CompiledActivatorModule.ActionType.USE_ITEM_ON_ENTITY;
    }

    @Override
    protected NBTTagCompound buildMessageData() {
        NBTTagCompound compound = super.buildMessageData();
        compound.func_74768_a("ActionType", this.actionType.ordinal());
        compound.func_74768_a("LookDirection", this.lookDirection.ordinal());
        compound.func_74757_a("Sneaking", this.isSneaking);
        return compound;
    }

    private static class SneakButton
    extends TexturedToggleButton {
        SneakButton(int buttonId, int x, int y, boolean initialVal) {
            super(buttonId, x, y, 16, 16);
            this.setToggled(initialVal);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 192 : 112;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private static class LookDirectionButton
    extends TexturedCyclerButton<CompiledActivatorModule.LookDirection> {
        private final List<List<String>> tooltips = Lists.newArrayList();

        LookDirectionButton(int buttonId, int x, int y, int width, int height, CompiledActivatorModule.LookDirection initialVal) {
            super(buttonId, x, y, width, height, initialVal);
            for (CompiledActivatorModule.LookDirection dir : CompiledActivatorModule.LookDirection.values()) {
                this.tooltips.add(Collections.singletonList(I18n.func_135052_a((String)("itemText.activator.direction." + (Object)((Object)dir)), (Object[])new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 144 + ((CompiledActivatorModule.LookDirection)((Object)this.getState())).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 0;
        }

        @Override
        public List<String> getTooltip() {
            return this.tooltips.get(((CompiledActivatorModule.LookDirection)((Object)this.getState())).ordinal());
        }
    }

    private static class ActionTypeButton
    extends ItemStackCyclerButton<CompiledActivatorModule.ActionType> {
        private final List<List<String>> tips = Lists.newArrayList();

        ActionTypeButton(int buttonId, int x, int y, int width, int height, boolean flat, ItemStack[] stacks, CompiledActivatorModule.ActionType initialVal) {
            super(buttonId, x, y, width, height, flat, stacks, initialVal);
            for (CompiledActivatorModule.ActionType actionType : CompiledActivatorModule.ActionType.values()) {
                this.tips.add(Collections.singletonList(I18n.func_135052_a((String)("itemText.activator.action." + (Object)((Object)actionType)), (Object[])new Object[0])));
            }
        }

        @Override
        public List<String> getTooltip() {
            return this.tips.get(((CompiledActivatorModule.ActionType)((Object)this.getState())).ordinal());
        }
    }
}

