/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.RedstoneBehaviourButton;
import me.desht.modularrouters.client.gui.widgets.GuiContainerBase;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.container.ContainerItemRouter;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.OpenGuiMessage;
import me.desht.modularrouters.network.RouterSettingsMessage;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiItemRouter
extends GuiContainerBase {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/router.png");
    public static final int LABEL_XPOS = 5;
    public static final int LABEL_YPOS = 5;
    public static final int MODULE_LABEL_YPOS = 60;
    public static final int BUFFER_LABEL_YPOS = 28;
    public static final int UPGRADES_LABEL_YPOS = 28;
    public static final int GUI_HEIGHT = 186;
    public static final int GUI_WIDTH = 176;
    public static final int BUTTON_HEIGHT = 16;
    public static final int BUTTON_WIDTH = 16;
    private static final int REDSTONE_BUTTON_ID = 1;
    private static final int ECO_BUTTON_ID = 2;
    public final TileEntityItemRouter router;
    private static final int MODULE_START = 37;
    private static final int MODULE_END = 45;

    public GuiItemRouter(InventoryPlayer inventoryPlayer, TileEntityItemRouter router) {
        super(new ContainerItemRouter(inventoryPlayer, router));
        this.field_146999_f = 176;
        this.field_147000_g = 186;
        this.router = router;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new RedstoneBehaviourButton(1, this.field_147003_i + 152, this.field_147009_r + 10, 16, 16, this.router.getRedstoneBehaviour()));
        this.field_146292_n.add(new RouterEcoButton(2, this.field_147003_i + 132, this.field_147009_r + 10, 16, 16, this.router.getEcoMode()));
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1: {
                RedstoneBehaviourButton rrb = (RedstoneBehaviourButton)button;
                rrb.cycle(!GuiItemRouter.func_146272_n());
                this.router.setRedstoneBehaviour((RouterRedstoneBehaviour)((Object)rrb.getState()));
                ModularRouters.network.sendToServer((IMessage)new RouterSettingsMessage(this.router));
                break;
            }
            case 2: {
                RouterEcoButton reb = (RouterEcoButton)button;
                reb.toggle();
                this.router.setEcoMode(reb.isToggled());
                ModularRouters.network.sendToServer((IMessage)new RouterSettingsMessage(this.router));
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String title = this.router.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(title) / 2, 5, Color.darkGray.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"guiText.label.buffer", (Object[])new Object[0]), 8, 28, Color.darkGray.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"guiText.label.upgrades", (Object[])new Object[0]), 80, 28, Color.darkGray.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"guiText.label.modules", (Object[])new Object[0]), 8, 60, Color.darkGray.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 4, Color.darkGray.getRGB());
    }

    protected void func_146976_a(float v, int i, int i1) {
        this.field_146297_k.func_110434_K().func_110577_a(textureLocation);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (typedChar != ConfigHandler.getConfigKey() || !this.handleModuleConfig()) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int btn) throws IOException {
        if (btn != 2 || !this.handleModuleConfig()) {
            super.func_73864_a(x, y, btn);
        }
    }

    private boolean handleModuleConfig() {
        Slot slot = this.getSlotUnderMouse();
        if (slot == null || ItemModule.getModule(slot.func_75211_c()) == null || slot.field_75222_d < 37 || slot.field_75222_d >= 45) {
            return false;
        }
        this.router.playerConfiguringModule((EntityPlayer)this.field_146297_k.field_71439_g, slot.field_75222_d - 37);
        ModularRouters.network.sendToServer((IMessage)OpenGuiMessage.openModuleInRouter(this.router.func_174877_v(), slot.getSlotIndex()));
        return true;
    }

    private static class RouterEcoButton
    extends TexturedToggleButton {
        RouterEcoButton(int buttonId, int x, int y, int width, int height, boolean initialVal) {
            super(buttonId, x, y, width, height);
            this.setToggled(initialVal);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 96 : 80;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }

        @Override
        public List<String> getTooltip() {
            return MiscUtil.wrapString(I18n.func_135052_a((String)("guiText.tooltip.eco." + this.isToggled()), (Object[])new Object[]{Float.valueOf((float)ConfigHandler.router.ecoTimeout / 20.0f), Float.valueOf((float)ConfigHandler.router.lowPowerTickRate / 20.0f)}));
        }
    }
}

