/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.BlockCamo;
import me.desht.modularrouters.util.PropertyObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;

public abstract class CamouflagingModel
implements IBakedModel {
    private final IBakedModel baseModel;
    private final PropertyObject<IBlockState> camoProp;

    public CamouflagingModel(IBakedModel baseModel, PropertyObject<IBlockState> camoProp) {
        this.baseModel = baseModel;
        this.camoProp = camoProp;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        try {
            return this.handleBlockState(state, side, rand);
        }
        catch (IllegalArgumentException e) {
            return this.baseModel.func_188616_a(state, side, rand);
        }
    }

    private List<BakedQuad> handleBlockState(IBlockState state, EnumFacing side, long rand) {
        IExtendedBlockState ext;
        IBlockState camoState;
        if (state instanceof IExtendedBlockState && (camoState = (IBlockState)(ext = (IExtendedBlockState)state).getValue(this.camoProp)) != null) {
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (layer != null && camoState.func_177230_c().canRenderInLayer(camoState, layer)) {
                BlockModelShapes blockModelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
                return blockModelShapes.func_178125_b(camoState).func_188616_a(camoState, side, rand);
            }
            return Collections.emptyList();
        }
        return this.baseModel.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.baseModel.func_188617_f();
    }

    public static class TemplateFrameModel
    extends CamouflagingModel {
        public static final ModelResourceLocation VARIANT_TAG = new ModelResourceLocation("modularrouters:templateFrame", "normal");

        public TemplateFrameModel(IBakedModel baseModel) {
            super(baseModel, BlockCamo.CAMOUFLAGE_STATE);
        }
    }

    public static class RouterModel
    extends CamouflagingModel {
        public RouterModel(IBakedModel baseModel) {
            super(baseModel, BlockCamo.CAMOUFLAGE_STATE);
        }
    }
}

