/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.EventBlockBitModification;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.ExceptionNoTileEntity;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.interfaces.IVoxelBlobItem;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketAccurateSneakPlace;
import mod.chiselsandbits.network.packets.PacketRotateVoxelBlob;
import mod.chiselsandbits.render.helpers.SimpleInstanceCache;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockChiseled
extends ItemBlock
implements IVoxelBlobItem,
IItemScrollWheel,
PacketAccurateSneakPlace.IItemBlockAccurate {
    SimpleInstanceCache<ItemStack, List<String>> tooltipCache = new SimpleInstanceCache(null, new ArrayList());

    public ItemBlockChiseled(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, worldIn, tooltip, advanced);
        ChiselsAndBits.getConfig().helpText(LocalStrings.HelpChiseledBlock, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getKeyName(ClientSide.getOffGridPlacementKey()));
        if (stack.func_77942_o()) {
            if (ClientSide.instance.holdingShift()) {
                if (this.tooltipCache.needsUpdate(stack)) {
                    VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
                    this.tooltipCache.updateCachedValue(blob.listContents(new ArrayList<String>()));
                }
                tooltip.addAll((Collection<String>)this.tooltipCache.getCached());
            } else {
                tooltip.add(LocalStrings.ShiftDetails.getLocal());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return this.canPlaceBlockHere(worldIn, pos, side, player, stack, false);
    }

    public boolean vanillaStylePlacementTest(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side, EntityPlayer player, ItemStack stack) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150431_aC) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(side);
        }
        return worldIn.func_190527_a(this.field_150939_a, pos, false, side, null);
    }

    public boolean canPlaceBlockHere(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side, EntityPlayer player, ItemStack stack, boolean offgrid) {
        if (this.vanillaStylePlacementTest(worldIn, pos, side, player, stack)) {
            return true;
        }
        if (offgrid) {
            return true;
        }
        if (ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, player, worldIn, pos, side, EnumHand.MAIN_HAND, null, false)) {
            return true;
        }
        return ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, player, worldIn, pos.func_177972_a(side), side, EnumHand.MAIN_HAND, null, false);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        PacketAccurateSneakPlace pasp = new PacketAccurateSneakPlace();
        pasp.hand = hand;
        pasp.pos = pos;
        pasp.side = side;
        pasp.stack = stack;
        pasp.offgrid = ClientSide.offGridPlacement(player);
        pasp.hitX = hitX;
        pasp.hitY = hitY;
        pasp.hitZ = hitZ;
        NetworkRouter.instance.sendToServer(pasp);
        return this.placeItem(stack, player, world, pos, hand, side, hitX, hitY, hitZ, ClientSide.offGridPlacement(player));
    }

    @Override
    public EnumActionResult placeItem(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ, boolean offgrid) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150431_aC && (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1) {
            side = EnumFacing.UP;
        } else {
            TileEntityBlockChiseled tebc;
            boolean canMerge = false;
            if (stack.func_77942_o() && (tebc = ModUtil.getChiseledTileEntity(worldIn, pos, true)) != null) {
                VoxelBlob blob = ModUtil.getBlobFromStack(stack, (EntityLivingBase)playerIn);
                canMerge = tebc.canMerge(blob);
            }
            if (!(canMerge || offgrid || block.func_176200_f((IBlockAccess)worldIn, pos))) {
                pos = pos.func_177972_a(side);
            }
        }
        if (ModUtil.isEmpty(stack)) {
            return EnumActionResult.FAIL;
        }
        if (!playerIn.func_175151_a(pos, side, stack)) {
            return EnumActionResult.FAIL;
        }
        if (pos.func_177956_o() == 255 && DeprecationHelper.getStateFromItem(stack).func_185904_a().func_76220_a()) {
            return EnumActionResult.FAIL;
        }
        if (this.canPlaceBlockHere(worldIn, pos, side, playerIn, stack, offgrid)) {
            int i = this.func_77647_b(stack.func_77960_j());
            IBlockState iblockstate1 = this.field_150939_a.getStateForPlacement(worldIn, pos, side, hitX, hitY, hitZ, i, (EntityLivingBase)playerIn, hand);
            if (this.placeBitBlock(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ, iblockstate1, offgrid)) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, DeprecationHelper.getSoundType(this.field_150939_a).func_185841_e(), SoundCategory.BLOCKS, (DeprecationHelper.getSoundType(this.field_150939_a).func_185843_a() + 1.0f) / 2.0f, DeprecationHelper.getSoundType(this.field_150939_a).func_185847_b() * 0.8f, false);
                ModUtil.adjustStackSize(stack, -1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        return this.placeBitBlock(stack, player, world, pos, side, hitX, hitY, hitZ, newState, false);
    }

    public boolean placeBitBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState, boolean offgrid) {
        if (offgrid) {
            BitLocation bl = new BitLocation(new RayTraceResult(RayTraceResult.Type.BLOCK, new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos), false, BitOperation.PLACE);
            return ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, player, world, bl.blockPos, side, EnumHand.MAIN_HAND, new BlockPos(bl.bitX, bl.bitY, bl.bitZ), true);
        }
        return ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, player, world, pos, side, EnumHand.MAIN_HAND, null, true);
    }

    public static boolean tryPlaceBlockAt(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull EnumHand hand, BlockPos partial, boolean modulateWorld) {
        try {
            TileEntityBlockChiseled target;
            int z;
            int y;
            int x;
            BlockPos offset;
            VoxelBlob[][][] blobs = new VoxelBlob[2][2][2];
            if (!stack.func_77942_o()) {
                return false;
            }
            VoxelBlob source = ModUtil.getBlobFromStack(stack, (EntityLivingBase)player);
            IntegerBox modelBounds = source.getBounds();
            BlockPos blockPos = offset = partial == null ? new BlockPos(0, 0, 0) : ModUtil.getPartialOffset(side, partial, modelBounds);
            if (offset.func_177958_n() < 0) {
                pos = pos.func_177982_a(-1, 0, 0);
                offset = offset.func_177982_a(16, 0, 0);
            }
            if (offset.func_177956_o() < 0) {
                pos = pos.func_177982_a(0, -1, 0);
                offset = offset.func_177982_a(0, 16, 0);
            }
            if (offset.func_177952_p() < 0) {
                pos = pos.func_177982_a(0, 0, -1);
                offset = offset.func_177982_a(0, 0, 16);
            }
            for (x = 0; x < 2; ++x) {
                for (y = 0; y < 2; ++y) {
                    for (z = 0; z < 2; ++z) {
                        blobs[x][y][z] = source.offset(offset.func_177958_n() - source.detail * x, offset.func_177956_o() - source.detail * y, offset.func_177952_p() - source.detail * z);
                        int solids = blobs[x][y][z].filled();
                        if (solids <= 0) continue;
                        BlockPos bp = pos.func_177982_a(x, y, z);
                        EventBlockBitModification bmm = new EventBlockBitModification(world, bp, player, hand, stack, true);
                        MinecraftForge.EVENT_BUS.post((Event)bmm);
                        if (!world.func_175660_a(player, bp) || bmm.isCanceled()) {
                            return false;
                        }
                        if (world.func_175623_d(bp) || world.func_180495_p(bp).func_177230_c().func_176200_f((IBlockAccess)world, bp)) continue;
                        target = ModUtil.getChiseledTileEntity(world, bp, true);
                        if (target != null) {
                            if (!target.canMerge(blobs[x][y][z])) {
                                return false;
                            }
                            blobs[x][y][z] = blobs[x][y][z].merge(target.getBlob());
                            continue;
                        }
                        return false;
                    }
                }
            }
            if (modulateWorld) {
                for (x = 0; x < 2; ++x) {
                    for (y = 0; y < 2; ++y) {
                        for (z = 0; z < 2; ++z) {
                            if (blobs[x][y][z].filled() <= 0) continue;
                            BlockPos bp = pos.func_177982_a(x, y, z);
                            IBlockState state = world.func_180495_p(bp);
                            if (world.func_180495_p(bp).func_177230_c().func_176200_f((IBlockAccess)world, bp)) {
                                world.func_175698_g(bp);
                            }
                            if (world.func_175623_d(bp)) {
                                int commonBlock = blobs[x][y][z].getVoxelStats().mostCommonState;
                                if (!BlockChiseled.replaceWithChisled(world, bp, state, commonBlock, true)) continue;
                                target = BlockChiseled.getTileEntity((IBlockAccess)world, bp);
                                target.completeEditOperation(blobs[x][y][z]);
                                continue;
                            }
                            TileEntityBlockChiseled target2 = ModUtil.getChiseledTileEntity(world, bp, true);
                            if (target2 != null) {
                                target2.completeEditOperation(blobs[x][y][z]);
                                continue;
                            }
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return false;
        }
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound BlockEntityTag;
        NBTTagCompound comp = stack.func_77978_p();
        if (comp != null && (BlockEntityTag = comp.func_74775_l("BlockEntityTag")) != null) {
            NBTBlobConverter c = new NBTBlobConverter();
            c.readChisleData(BlockEntityTag, -1);
            IBlockState state = c.getPrimaryBlockState();
            String name = ItemChiseledBit.getBitStateName(state);
            if (name != null) {
                return super.func_77653_i(stack) + " - " + name;
            }
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void scroll(EntityPlayer player, ItemStack stack, int dwheel) {
        PacketRotateVoxelBlob p = new PacketRotateVoxelBlob();
        p.rotationDirection = dwheel;
        NetworkRouter.instance.sendToServer(p);
    }

    @Override
    public void rotate(ItemStack stack, int rotationDirection) {
        EnumFacing side = ModUtil.getSide(stack);
        side = rotationDirection > 0 ? side.func_176746_e() : side.func_176735_f();
        ModUtil.setSide(stack, side);
    }
}

