/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client;

import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonBase;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    public static void glScissor(int x, int y, int width, int height) {
        GL11.glEnable((int)3089);
        int scaleFactor = GuiHelper.getScaleFactor();
        GL11.glScissor((int)(x * scaleFactor), (int)(GuiHelper.getMinecraft().field_71440_d - (y + height) * scaleFactor), (int)(width * scaleFactor), (int)(height * scaleFactor));
    }

    public static void glScissorDisable() {
        GL11.glDisable((int)3089);
    }

    public static int getScaleFactor() {
        return new ScaledResolution(GuiHelper.getMinecraft()).func_78325_e();
    }

    public static GuiScreen getOpenGui() {
        return GuiHelper.getMinecraft().field_71462_r;
    }

    public static boolean isCursorInsideBox(AxisAlignedBB box, int mouseX, int mouseY) {
        return box.func_186662_g(1.0).func_72318_a(new Vec3d((double)mouseX, (double)mouseY, 0.0));
    }

    public static void drawRect(double left, double top, double right, double bottom, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(left, bottom, 0.0).func_181675_d();
        buffer.func_181662_b(right, bottom, 0.0).func_181675_d();
        buffer.func_181662_b(right, top, 0.0).func_181675_d();
        buffer.func_181662_b(left, top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedRect(double left, double top, double right, double bottom) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buffer = t.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(left, top, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(left, bottom, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(right, bottom, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(right, top, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179084_k();
    }

    public static void drawHoveringTextForButtons(GuiScreen gui, List<GuiButton> buttonList, int mouseX, int mouseY) {
        for (GuiButton button : buttonList) {
            if (!(button instanceof GuiButtonBase) || !button.func_146115_a() || !button.field_146125_m) continue;
            String text = ((GuiButtonBase)button).getHoverText();
            if (text.isEmpty()) break;
            gui.func_146279_a(text, mouseX, mouseY);
            break;
        }
    }

    public static Pair<Float, Boolean> changeScale(float scale, float amount, float max) {
        amount *= scale;
        float previewStackInitialScale = scale;
        if ((double)(scale += amount) < 0.1) {
            scale = 0.1f;
            return new ImmutablePair((Object)Float.valueOf(previewStackInitialScale), (Object)true);
        }
        if (scale > max) {
            scale = max;
            return new ImmutablePair((Object)Float.valueOf(previewStackInitialScale), (Object)true);
        }
        return new ImmutablePair((Object)Float.valueOf(scale), (Object)false);
    }

    public static Triple<Vec3d, Vec3d, Float> dragObject(int clickedMouseButton, float deltaX, float deltaY, Vec3d translationInitialVec, Vec3d rotationVec, float scale, float scaleMax, float rotationMultiplierX, float rotationMultiplierY, boolean affectRotation) {
        MutableTriple triple = new MutableTriple((Object)translationInitialVec, (Object)rotationVec, (Object)Float.valueOf(scale));
        if (clickedMouseButton == 0) {
            if (GuiScreen.func_146272_n() || GuiScreen.func_146271_m()) {
                triple.setRight(GuiHelper.changeScale(scale, deltaY * 0.05f, scaleMax).getLeft());
            } else if (affectRotation) {
                double angleX = rotationVec.field_72450_a - (double)(deltaY / scale * rotationMultiplierX);
                double angleY = rotationVec.field_72448_b - (double)(deltaX / scale * rotationMultiplierY);
                if (angleX < -90.0 || angleX > 90.0) {
                    angleX = 90 * (angleX > 0.0 ? 1 : -1);
                }
                triple.setMiddle((Object)new Vec3d(angleX, angleY, 0.0));
            }
        } else if (clickedMouseButton == 1) {
            triple.setLeft((Object)new Vec3d(translationInitialVec.field_72450_a - (double)deltaX, translationInitialVec.field_72448_b - (double)deltaY, 0.0));
        }
        return triple;
    }

    public static Pair<Vec3d, Float> scaleObjectWithMouseWheel(GuiScreen screen, AxisAlignedBB box, Vec3d translationVec, float scale, float scaleMax, float yOffset) {
        int mouseY;
        MutablePair pair = new MutablePair((Object)translationVec, (Object)Float.valueOf(scale));
        if (Mouse.getEventDWheel() == 0) {
            return pair;
        }
        int mouseX = Mouse.getEventX() * screen.field_146294_l / screen.field_146297_k.field_71443_c;
        if (!GuiHelper.isCursorInsideBox(box, mouseX, mouseY = screen.field_146295_m - Mouse.getEventY() * screen.field_146295_m / screen.field_146297_k.field_71440_d - 1)) {
            return pair;
        }
        float amount = Mouse.getEventDWheel();
        Pair<Float, Boolean> scaleNew = GuiHelper.changeScale(scale, amount * 0.005f, scaleMax);
        if (((Boolean)scaleNew.getRight()).booleanValue()) {
            return pair;
        }
        pair.setRight(scaleNew.getLeft());
        float x = mouseX - (int)(translationVec.field_72450_a + (box.field_72336_d + box.field_72340_a) * 0.5);
        float y = mouseY - (int)(translationVec.field_72448_b + (double)yOffset + (box.field_72337_e + box.field_72338_b) * 0.5);
        float offset = amount / -30.0f * 0.15f;
        pair.setLeft((Object)translationVec.func_72441_c((double)(x * offset), (double)(y * offset), 0.0));
        return pair;
    }
}

