/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor.capability;

import com.phylogeny.extrabitmanipulation.armor.capability.ChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiButtonArmorSlots;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiInventoryArmorSlots;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.ReflectionExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ChiseledArmorSlotsEventHandler {
    @SubscribeEvent
    public void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("extrabitmanipulation", "chiseled_armor_slots"), (ICapabilityProvider)new ChiseledArmorSlotsHandler());
        }
    }

    @SubscribeEvent
    public void syncDataForNewPlayers(EntityJoinWorldEvent event) {
        IChiseledArmorSlotsHandler cap;
        Entity player = event.getEntity();
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP && (cap = ChiseledArmorSlotsHandler.getCapability((EntityPlayer)player)) != null) {
            cap.syncAllData((EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void syncDataForClonedPlayers(PlayerEvent.Clone event) {
        IChiseledArmorSlotsHandler capNew;
        if (!event.isWasDeath()) {
            return;
        }
        IChiseledArmorSlotsHandler capOld = ChiseledArmorSlotsHandler.getCapability(event.getOriginal());
        if (capOld != null && (capNew = ChiseledArmorSlotsHandler.getCapability((EntityPlayer)event.getEntity())) != null) {
            ((ChiseledArmorSlotsHandler)capNew).deserializeNBT(((ChiseledArmorSlotsHandler)capOld).serializeNBT());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dropArmorOnDeath(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability(player);
        if (cap == null) {
            return;
        }
        for (int i = 0; i < ItemChiseledArmor.ArmorType.values().length; ++i) {
            if (cap.getStackInSlot(i).func_190926_b()) continue;
            player.captureDrops = true;
            player.func_146097_a(cap.getStackInSlot(i).func_77946_l(), true, false);
            player.captureDrops = false;
            cap.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addArmorButtonToGui(GuiScreenEvent.InitGuiEvent.Post event) {
        EntityPlayer player = ClientHelper.getPlayer();
        if (player == null || player.field_71075_bZ.field_75098_d) {
            return;
        }
        boolean isArmorSlots = event.getGui() instanceof GuiInventoryArmorSlots;
        if (!isArmorSlots && !(event.getGui() instanceof GuiInventory)) {
            return;
        }
        GuiContainer gui = (GuiContainer)event.getGui();
        boolean add = false;
        IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability(player);
        if (cap != null) {
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (cap.getStackInSlot(i).func_190926_b()) continue;
                add = true;
                break;
            }
        }
        if (!add) {
            ArmorButtonVisibiltyMode mode = Configs.armorButtonVisibiltyMode;
            boolean bl = add = isArmorSlots || mode == ArmorButtonVisibiltyMode.ALWAYS;
            if (!isArmorSlots && mode != ArmorButtonVisibiltyMode.NEVER && mode != ArmorButtonVisibiltyMode.ALWAYS) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ResourceLocation name;
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    if (mode == ArmorButtonVisibiltyMode.ANY_ITEMS || mode == ArmorButtonVisibiltyMode.CHISELED_ARMOR_ITEMS) {
                        if (mode != ArmorButtonVisibiltyMode.ANY_ITEMS && !ItemStackHelper.isChiseledArmorStack(stack)) continue;
                        add = true;
                        break;
                    }
                    Item item = stack.func_77973_b();
                    if (item == null || (name = item.getRegistryName()) == null || !name.func_110624_b().equals("extrabitmanipulation") && (mode != ArmorButtonVisibiltyMode.EBM_OR_CNB_ITEMS || !name.func_110624_b().equals("chiselsandbits"))) continue;
                    add = true;
                    break;
                }
            }
        }
        if (add) {
            GuiButtonArmorSlots button = new GuiButtonArmorSlots(gui, isArmorSlots ? "Back" : "Chiseled Armor");
            if (isArmorSlots) {
                button.setHelpMode(((GuiInventoryArmorSlots)gui).isInHelpMode());
            }
            event.getButtonList().add(button);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void resetArmorButtonPosition(GuiScreenEvent.KeyboardInputEvent.Post event) {
        if (!Keyboard.isKeyDown((int)19) || !GuiButtonArmorSlots.shouldMoveButton() || !(event.getGui() instanceof GuiInventoryArmorSlots) && !(event.getGui() instanceof GuiInventory) || Configs.armorButtonX.isAtDefaultValue() && Configs.armorButtonY.isAtDefaultValue()) {
            return;
        }
        List<GuiButton> buttonList = ReflectionExtraBitManipulation.getButtonList(event.getGui());
        for (GuiButton button : buttonList) {
            if (!(button instanceof GuiButtonArmorSlots)) continue;
            BitToolSettingsHelper.setArmorButtonPosition((Integer)Configs.armorButtonX.getDefaultValue(), (Integer)Configs.armorButtonY.getDefaultValue());
            ((GuiButtonArmorSlots)button).setPosition();
            break;
        }
    }

    public static enum ArmorButtonVisibiltyMode {
        CHISELED_ARMOR_ITEMS,
        EBM_ITEMS,
        EBM_OR_CNB_ITEMS,
        ANY_ITEMS,
        ALWAYS,
        NEVER;

    }
}

