/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.master;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mrriegel.storagenetwork.IConnectable;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.cable.TileCable;
import mrriegel.storagenetwork.config.ConfigHandler;
import mrriegel.storagenetwork.data.FilterItem;
import mrriegel.storagenetwork.data.StackWrapper;
import mrriegel.storagenetwork.helper.NBTHelper;
import mrriegel.storagenetwork.helper.UtilInventory;
import mrriegel.storagenetwork.helper.UtilTileEntity;
import mrriegel.storagenetwork.tile.AbstractFilterTile;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileMaster
extends TileEntity
implements ITickable {
    public Set<BlockPos> connectables;
    public List<BlockPos> storageInventorys;

    public List<StackWrapper> getStacks() {
        ArrayList stacks = Lists.newArrayList();
        ArrayList invs = Lists.newArrayList();
        if (this.connectables == null) {
            this.refreshNetwork();
        }
        for (BlockPos p : this.connectables) {
            AbstractFilterTile tile;
            if (!(this.field_145850_b.func_175625_s(p) instanceof AbstractFilterTile) || !(tile = (AbstractFilterTile)this.field_145850_b.func_175625_s(p)).isStorage() || tile.getInventory() == null) continue;
            invs.add(tile);
        }
        for (AbstractFilterTile t : invs) {
            IItemHandler inv = t.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (inv.getStackInSlot(i) == null || inv.getStackInSlot(i).func_190926_b() || !t.canTransfer(inv.getStackInSlot(i), AbstractFilterTile.Direction.BOTH)) continue;
                this.addToList(stacks, inv.getStackInSlot(i).func_77946_l(), inv.getStackInSlot(i).func_190916_E());
            }
        }
        return stacks;
    }

    public int emptySlots() {
        int res = 0;
        ArrayList invs = Lists.newArrayList();
        for (BlockPos p : this.connectables) {
            AbstractFilterTile tile;
            if (!(this.field_145850_b.func_175625_s(p) instanceof AbstractFilterTile) || !(tile = (AbstractFilterTile)this.field_145850_b.func_175625_s(p)).isStorage() || tile.getInventory() == null) continue;
            invs.add(tile);
        }
        for (AbstractFilterTile t : invs) {
            IItemHandler inv = t.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (inv.getStackInSlot(i) != null && !inv.getStackInSlot(i).func_190926_b()) continue;
                ++res;
            }
        }
        return res;
    }

    public List<StackWrapper> getCraftableStacks(List<StackWrapper> stacks) {
        ArrayList craftableStacks = Lists.newArrayList();
        return craftableStacks;
    }

    private void addToList(List<StackWrapper> lis, ItemStack s, int num) {
        boolean added = false;
        for (int i = 0; i < lis.size(); ++i) {
            ItemStack stack = lis.get(i).getStack();
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
            lis.get(i).setSize(lis.get(i).getSize() + num);
            added = true;
        }
        if (!added) {
            lis.add(new StackWrapper(s, num));
        }
    }

    public int getAmount(FilterItem fil) {
        if (fil == null) {
            return 0;
        }
        int size = 0;
        for (StackWrapper w : this.getStacks()) {
            if (!fil.match(w.getStack())) continue;
            size += w.getSize();
        }
        return size;
    }

    public List<FilterItem> getIngredients(ItemStack template) {
        HashMap stacks = Maps.newHashMap();
        HashMap metas = Maps.newHashMap();
        HashMap ores = Maps.newHashMap();
        NBTTagList invList = template.func_77978_p().func_150295_c("crunchItem", 10);
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = invList.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            stacks.put(Integer.valueOf(slot), new ItemStack(stackTag));
        }
        ArrayList list = Lists.newArrayList();
        for (int i = 1; i < 10; ++i) {
            metas.put(i - 1, NBTHelper.getBoolean(template, "meta" + i));
            ores.put(i - 1, NBTHelper.getBoolean(template, "ore" + i));
        }
        for (Map.Entry e : stacks.entrySet()) {
            if (e.getValue() == null) continue;
            boolean meta = (Boolean)metas.get(e.getKey());
            boolean ore = (Boolean)ores.get(e.getKey());
            list.add(new FilterItem((ItemStack)e.getValue(), meta, ore, false));
        }
        return list;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    private void addConnectables(BlockPos pos) {
        if (pos == null || this.field_145850_b == null || !this.func_145831_w().func_175667_e(pos)) {
            return;
        }
        for (BlockPos bl : UtilTileEntity.getSides(pos)) {
            Chunk chunk;
            if (!this.func_145831_w().func_175667_e(bl) || (chunk = this.field_145850_b.func_175726_f(bl)) == null || !chunk.func_177410_o()) continue;
            if (this.field_145850_b.func_175625_s(bl) != null && this.field_145850_b.func_175625_s(bl) instanceof TileMaster && !bl.equals((Object)this.field_174879_c)) {
                this.field_145850_b.func_180495_p(bl).func_177230_c().func_176226_b(this.field_145850_b, bl, this.field_145850_b.func_180495_p(bl), 0);
                this.field_145850_b.func_175698_g(bl);
                this.field_145850_b.func_175713_t(bl);
                continue;
            }
            if (this.field_145850_b.func_175625_s(bl) == null || !(this.field_145850_b.func_175625_s(bl) instanceof IConnectable) || this.connectables.contains(bl)) continue;
            this.connectables.add(bl);
            ((IConnectable)this.field_145850_b.func_175625_s(bl)).setMaster(this.field_174879_c);
            chunk.func_177427_f(true);
            this.addConnectables(bl);
        }
    }

    private void addInventorys() {
        this.storageInventorys = Lists.newArrayList();
        for (BlockPos cable : this.connectables) {
            BlockPos pos;
            AbstractFilterTile s;
            if (!(this.field_145850_b.func_175625_s(cable) instanceof AbstractFilterTile) || (s = (AbstractFilterTile)this.field_145850_b.func_175625_s(cable)).getInventory() == null || !s.isStorage() || !this.field_145850_b.func_175726_f(pos = s.getSource()).func_177410_o()) continue;
            this.storageInventorys.add(pos);
        }
    }

    public void refreshNetwork() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.connectables = Sets.newHashSet();
        try {
            this.addConnectables(this.field_174879_c);
        }
        catch (Error e) {
            e.printStackTrace();
        }
        this.addInventorys();
        this.field_145850_b.func_175726_f(this.field_174879_c).func_177427_f(true);
    }

    public int insertStack(ItemStack stack, BlockPos source, boolean simulate) {
        ItemStack remain;
        IItemHandler inv;
        if (stack == null || stack.func_190926_b()) {
            return 0;
        }
        ArrayList invs = Lists.newArrayList();
        if (this.connectables == null) {
            this.refreshNetwork();
        }
        for (BlockPos p : this.connectables) {
            AbstractFilterTile tile;
            if (!(this.field_145850_b.func_175625_s(p) instanceof AbstractFilterTile) || !(tile = (AbstractFilterTile)this.field_145850_b.func_175625_s(p)).isStorage() || tile.getInventory() == null) continue;
            invs.add(tile);
        }
        Collections.sort(invs, new Comparator<AbstractFilterTile>(){

            @Override
            public int compare(AbstractFilterTile o1, AbstractFilterTile o2) {
                return Integer.compare(o2.getPriority(), o1.getPriority());
            }
        });
        ItemStack in = stack.func_77946_l();
        for (AbstractFilterTile t : invs) {
            inv = t.getInventory();
            if (!UtilInventory.contains(inv, in) || !t.canTransfer(in, AbstractFilterTile.Direction.IN) || t.getSource().equals((Object)source)) continue;
            remain = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)in, (boolean)simulate);
            if (remain == null || remain.func_190926_b()) {
                return 0;
            }
            in = ItemHandlerHelper.copyStackWithSize((ItemStack)in, (int)remain.func_190916_E());
            this.field_145850_b.func_175646_b(t.getSource(), this.field_145850_b.func_175625_s(t.getSource()));
        }
        for (AbstractFilterTile t : invs) {
            inv = t.getInventory();
            if (UtilInventory.contains(inv, in) || !t.canTransfer(in, AbstractFilterTile.Direction.IN) || t.getSource().equals((Object)source)) continue;
            remain = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)in, (boolean)simulate);
            if (remain == null || remain.func_190926_b()) {
                return 0;
            }
            in = ItemHandlerHelper.copyStackWithSize((ItemStack)in, (int)remain.func_190916_E());
            this.field_145850_b.func_175646_b(t.getSource(), this.field_145850_b.func_175625_s(t.getSource()));
        }
        return in.func_190916_E();
    }

    public void updateImports() {
        List<TileCable> attachedCables = this.getAttachedCables(TileCable.CableKind.imKabel);
        block0: for (TileCable tileCable : attachedCables) {
            IItemHandler inv = tileCable.getInventory();
            int speedRatio = tileCable.getUpgradesOfType(0) + 1;
            if (this.field_145850_b.func_82737_E() % (long)(30 / speedRatio) != 0L) continue;
            boolean hasStackUpgrade = tileCable.getUpgradesOfType(2) > 0;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stackCurrent = inv.getStackInSlot(i);
                if (stackCurrent == null || stackCurrent.func_190926_b() || !tileCable.canTransfer(stackCurrent, AbstractFilterTile.Direction.OUT) || !tileCable.doesPassOperationFilterLimit()) continue;
                int maxInsert = hasStackUpgrade ? 64 : 4;
                int insert = Math.min(stackCurrent.func_190916_E(), maxInsert);
                ItemStack extracted = inv.extractItem(i, insert, true);
                if (extracted == null || extracted.func_190916_E() < insert) continue;
                int rest = this.insertStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stackCurrent, (int)insert), tileCable.getConnectedInventory(), false);
                inv.extractItem(i, insert - rest, false);
                this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
                continue block0;
            }
        }
    }

    public void updateExports() {
        List<TileCable> attachedCables = this.getAttachedCables(TileCable.CableKind.exKabel);
        block0: for (TileCable tileCable : attachedCables) {
            if (tileCable == null || tileCable.getInventory() == null || (this.field_145850_b.func_82737_E() + 20L) % (long)(30 / (tileCable.getUpgradesOfType(0) + 1)) != 0L) continue;
            IItemHandler inv = tileCable.getInventory();
            boolean ore = tileCable.getOre();
            boolean meta = tileCable.getMeta();
            Map<Integer, StackWrapper> tilesFilter = tileCable.getFilter();
            for (int i = 0; i < 18; ++i) {
                ItemStack rec;
                ItemStack stackCurrent;
                ItemStack stackToFilter;
                StackWrapper currentFilter;
                if (this.storageInventorys.contains(tileCable.func_174877_v()) || (currentFilter = tilesFilter.get(i)) == null || (stackToFilter = currentFilter.getStack().func_77946_l()) == null || stackToFilter.func_190926_b() || (stackCurrent = this.request(new FilterItem(stackToFilter, meta, ore, false), 1, true)) == null || stackCurrent.func_190926_b()) continue;
                int maxStackSize = stackCurrent.func_77976_d();
                if (tileCable.getUpgradesOfType(3) > 0) {
                    maxStackSize = Math.min(maxStackSize, currentFilter.getSize() - UtilInventory.getAmount(inv, new FilterItem(stackCurrent, meta, ore, false)));
                }
                if (maxStackSize <= 0) continue;
                ItemStack max = ItemHandlerHelper.copyStackWithSize((ItemStack)stackCurrent, (int)maxStackSize);
                ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)max, (boolean)true);
                int insert = remain == null ? max.func_190916_E() : max.func_190916_E() - remain.func_190916_E();
                insert = Math.min(insert, (int)Math.pow(2.0, tileCable.getUpgradesOfType(2) + 2));
                if (!tileCable.doesPassOperationFilterLimit() || (rec = this.request(new FilterItem(stackCurrent, meta, ore, false), insert, false)) == null || rec.func_190926_b()) continue;
                ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)rec, (boolean)false);
                this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
                continue block0;
            }
        }
    }

    public List<TileCable> getAttachedCables(TileCable.CableKind kind) {
        ArrayList attachedCables = Lists.newArrayList();
        for (BlockPos p : this.connectables) {
            TileCable tile;
            if (!(this.field_145850_b.func_175625_s(p) instanceof TileCable) || (tile = (TileCable)this.field_145850_b.func_175625_s(p)).getKind() != kind || tile.getInventory() == null) continue;
            attachedCables.add(tile);
        }
        Collections.sort(attachedCables, new Comparator<TileCable>(){

            @Override
            public int compare(TileCable o1, TileCable o2) {
                return Integer.compare(o1.getPriority(), o2.getPriority());
            }
        });
        return attachedCables;
    }

    public ItemStack request(FilterItem fil, int size, boolean simulate) {
        if (size == 0 || fil == null) {
            return ItemStack.field_190927_a;
        }
        ArrayList invs = Lists.newArrayList();
        for (BlockPos p : this.connectables) {
            AbstractFilterTile tile;
            if (!(this.field_145850_b.func_175625_s(p) instanceof AbstractFilterTile) || !(tile = (AbstractFilterTile)this.field_145850_b.func_175625_s(p)).isStorage() || tile.getInventory() == null) continue;
            invs.add(tile);
        }
        ItemStack res = ItemStack.field_190927_a;
        int result = 0;
        for (AbstractFilterTile t : invs) {
            IItemHandler inv = t.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stackCurrent = inv.getStackInSlot(i);
                if (stackCurrent == null || stackCurrent.func_190926_b() || res != null && !res.func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stackCurrent, (ItemStack)res) || !fil.match(stackCurrent) || !t.canTransfer(stackCurrent, AbstractFilterTile.Direction.OUT)) continue;
                int miss = size - result;
                ItemStack extracted = inv.extractItem(i, Math.min(inv.getStackInSlot(i).func_190916_E(), miss), simulate);
                result += Math.min(extracted.func_190926_b() ? stackCurrent.func_190916_E() : extracted.func_190916_E(), miss);
                res = stackCurrent.func_77946_l();
                if (res.func_190926_b()) {
                    res = extracted.func_77946_l();
                    res.func_190920_e(result);
                }
                StorageNetwork.log(t.func_174877_v() + "?" + size + "!TileMaster:request: yes actually remove items from source now " + res + "__" + result);
                if (result != size) continue;
                return ItemHandlerHelper.copyStackWithSize((ItemStack)res, (int)size);
            }
        }
        if (result == 0) {
            return ItemStack.field_190927_a;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)res, (int)result);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        try {
            if (this.storageInventorys == null || this.connectables == null || this.field_145850_b.func_82737_E() % ConfigHandler.refreshTicks == 0L) {
                this.refreshNetwork();
            }
            this.updateImports();
            this.updateExports();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.func_189515_b(syncData);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

