/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork;

import mrriegel.storagenetwork.IConnectable;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.helper.UtilTileEntity;
import mrriegel.storagenetwork.master.TileMaster;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractBlockConnectable
extends BlockContainer {
    public AbstractBlockConnectable(Material materialIn) {
        super(materialIn);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        try {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile != null && tile instanceof IConnectable) {
                IConnectable conUnitNeedsMaster = (IConnectable)worldIn.func_175625_s(pos);
                for (BlockPos p : UtilTileEntity.getSides(pos)) {
                    if (worldIn.func_175625_s(p) instanceof IConnectable) {
                        IConnectable conUnit = (IConnectable)worldIn.func_175625_s(p);
                        if (conUnit.getMaster() == null) continue;
                        conUnitNeedsMaster.setMaster(conUnit.getMaster());
                        continue;
                    }
                    if (!(worldIn.func_175625_s(p) instanceof TileMaster)) continue;
                    conUnitNeedsMaster.setMaster(p);
                }
            }
            this.setConnections(worldIn, pos, state, true);
        }
        catch (Exception e) {
            StorageNetwork.instance.logger.error("StorageNetwork: exception thrown while updating neighbours:", (Throwable)e);
        }
    }

    public void setConnections(World worldIn, BlockPos pos, IBlockState state, boolean refresh) {
        IConnectable tile = (IConnectable)worldIn.func_175625_s(pos);
        if (tile.getMaster() == null) {
            for (BlockPos p : UtilTileEntity.getSides(pos)) {
                if (!(worldIn.func_175625_s(p) instanceof TileMaster)) continue;
                tile.setMaster(p);
                break;
            }
        }
        if (tile.getMaster() != null) {
            TileEntity mas;
            block7: {
                mas = worldIn.func_175625_s(tile.getMaster());
                tile.setMaster(null);
                worldIn.func_175646_b(((TileEntity)tile).func_174877_v(), (TileEntity)tile);
                try {
                    this.setAllMastersNull(worldIn, pos);
                }
                catch (Error e) {
                    e.printStackTrace();
                    if (!(mas instanceof TileMaster)) break block7;
                    for (BlockPos p : ((TileMaster)mas).connectables) {
                        if (!worldIn.func_175726_f(p).func_177410_o() || !(worldIn.func_175625_s(p) instanceof IConnectable)) continue;
                        ((IConnectable)worldIn.func_175625_s(p)).setMaster(null);
                        worldIn.func_175646_b(p, worldIn.func_175625_s(p));
                    }
                }
            }
            if (refresh && mas instanceof TileMaster) {
                ((TileMaster)mas).refreshNetwork();
            }
        }
        worldIn.func_175646_b(((TileEntity)tile).func_174877_v(), (TileEntity)tile);
    }

    private void setAllMastersNull(World world, BlockPos pos) {
        ((IConnectable)world.func_175625_s(pos)).setMaster(null);
        for (BlockPos bl : UtilTileEntity.getSides(pos)) {
            if (!world.func_175726_f(bl).func_177410_o() || !(world.func_175625_s(bl) instanceof IConnectable) || ((IConnectable)world.func_175625_s(bl)).getMaster() == null) continue;
            ((IConnectable)world.func_175625_s(bl)).setMaster(null);
            world.func_175646_b(bl, world.func_175625_s(bl));
            this.setAllMastersNull(world, bl);
        }
    }
}

