/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import net.blay09.mods.farmingforblockheads.block.BlockFertilizedFarmland;
import net.blay09.mods.farmingforblockheads.item.ModItems;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FarmlandHandler {
    @SubscribeEvent
    public void onGrowEvent(BlockEvent.CropGrowEvent.Post event) {
        IBlockState plant = event.getWorld().func_180495_p(event.getPos());
        if (plant.func_177230_c() instanceof IGrowable) {
            IGrowable growable = (IGrowable)plant.func_177230_c();
            IBlockState farmland = event.getWorld().func_180495_p(event.getPos().func_177977_b());
            if (farmland.func_177230_c() instanceof BlockFertilizedFarmland && Math.random() <= (double)((BlockFertilizedFarmland)farmland.func_177230_c()).getDoubleGrowthChance() && growable.func_176473_a(event.getWorld(), event.getPos(), plant, event.getWorld().field_72995_K)) {
                growable.func_176474_b(event.getWorld(), event.getWorld().field_73012_v, event.getPos(), plant);
                event.getWorld().func_175718_b(2005, event.getPos(), 0);
                this.rollRegression(event.getWorld(), event.getPos(), farmland);
            }
        }
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        IBlockState plant = event.getWorld().func_180495_p(event.getPos());
        IBlockState farmland = event.getWorld().func_180495_p(event.getPos().func_177977_b());
        if (farmland.func_177230_c() instanceof BlockFertilizedFarmland && plant.func_177230_c() instanceof IGrowable && Math.random() <= (double)((BlockFertilizedFarmland)farmland.func_177230_c()).getBonusCropChance()) {
            event.getDrops().stream().filter(p -> !this.isProbablySeed((ItemStack)p)).findAny().ifPresent(c -> {
                event.getDrops().add(c.func_77946_l());
                event.getWorld().func_175718_b(2005, event.getPos(), 0);
                this.rollRegression(event.getWorld(), event.getPos(), farmland);
            });
        }
    }

    @SubscribeEvent
    public void onFertilize(PlayerInteractEvent.RightClickBlock event) {
        IBlockState farmland;
        if (!event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() == ModItems.fertilizer && (farmland = event.getWorld().func_180495_p(event.getPos().func_177977_b())).func_177230_c() == Blocks.field_150458_ak && ModItems.fertilizer.func_180614_a(event.getEntityPlayer(), event.getWorld(), event.getPos().func_177977_b(), event.getHand(), EnumFacing.UP, (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c) == EnumActionResult.SUCCESS) {
            event.setCanceled(true);
        }
    }

    private void rollRegression(World world, BlockPos pos, IBlockState farmland) {
        if (farmland.func_177230_c() instanceof BlockFertilizedFarmland && Math.random() <= (double)((BlockFertilizedFarmland)farmland.func_177230_c()).getRegressionChance()) {
            world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, farmland.func_177229_b((IProperty)BlockFarmland.field_176531_a)));
        }
    }

    private boolean isProbablySeed(ItemStack itemStack) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        return registryName != null && registryName.func_110623_a().contains("seed");
    }
}

