/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.playerupgrade;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilEntity;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.net.PacketSyncPlayerHealth;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHeartContainer
extends ItemFood
implements IHasRecipe,
IHasConfig {
    private static final int numFood = 2;
    private static final int numHearts = 1;
    public static int defaultHearts = 10;
    private static int maxHearts = 20;

    public ItemHeartContainer() {
        super(2, false);
        this.func_77848_i();
    }

    private boolean isPlayerMaxHearts(EntityPlayer player) {
        return UtilEntity.getMaxHealth((EntityLivingBase)player) / 2.0 >= (double)maxHearts;
    }

    protected void func_77849_c(ItemStack par1ItemStack, World world, EntityPlayer player) {
        CapabilityRegistry.IPlayerExtendedProperties prop = CapabilityRegistry.getPlayerProperties(player);
        if (this.isPlayerMaxHearts(player)) {
            UtilSound.playSound(player, SoundEvents.field_187646_bt);
            return;
        }
        int newVal = UtilEntity.incrementMaxHealth((EntityLivingBase)player, 2);
        prop.setMaxHealth(newVal);
        UtilSound.playSound(player, SoundRegistry.heart_container);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), Items.field_185164_cV, Items.field_179558_bo, Items.field_151158_bO, "gemDiamond", Items.field_151105_aU, "blockEmerald", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), Items.field_151153_ao, Items.field_151170_bI);
    }

    @SubscribeEvent
    public void onPlayerWarp(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityRegistry.IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties(event.player);
        if (props.getMaxHealth() > 0 && event.player instanceof EntityPlayerMP) {
            ModCyclic.network.sendTo((IMessage)new PacketSyncPlayerHealth(props.getMaxHealth()), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        CapabilityRegistry.IPlayerExtendedProperties src = CapabilityRegistry.getPlayerProperties(event.getOriginal());
        CapabilityRegistry.IPlayerExtendedProperties dest = CapabilityRegistry.getPlayerProperties(event.getEntityPlayer());
        dest.setDataFromNBT(src.getDataAsNBT());
        if (src.getMaxHealth() > 0) {
            UtilEntity.setMaxHealth((EntityLivingBase)event.getEntityPlayer(), src.getMaxHealth());
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        maxHearts = config.getInt("HeartContainerMax", "modpacks", 20, 10, 100, "Maximum number of heart containers you can get by eating heart containers.  Does not limit the /sethearts command");
        defaultHearts = config.getInt("HeartContainerDefault", "cyclicmagic.player", 10, 1, 100, "Default number of heart containers a new player will start with when first joining the world.  Will not affect existing players once they have joined.  (For Maximum heart limit given by the heart container see 'modpacks' category in the config file)");
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(UtilChat.lang(this.func_77658_a() + ".tooltip"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (this.isPlayerMaxHearts(playerIn)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }
}

