/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.ITileStackWrapper;
import com.lothrazar.cyclicmagic.core.gui.StackWrapper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTileStackWrapped
implements IMessage,
IMessageHandler<PacketTileStackWrapped, IMessage> {
    private BlockPos pos;
    private int index;
    private StackWrapper stack;

    public PacketTileStackWrapped() {
    }

    public PacketTileStackWrapped(int index, StackWrapper stack, BlockPos p) {
        this.pos = p;
        this.stack = stack;
        this.index = index;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.index = tags.func_74762_e("index");
        this.pos = new BlockPos(x, y, z);
        this.stack = StackWrapper.loadStackWrapperFromNBT((NBTTagCompound)tags.func_74781_a("ghostSlot"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("index", this.index);
        NBTTagCompound stackTag = new NBTTagCompound();
        this.stack.writeToNBT(stackTag);
        tags.func_74782_a("ghostSlot", (NBTBase)stackTag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketTileStackWrapped message, MessageContext ctx) {
        PacketTileStackWrapped.checkThreadAndEnqueue(message, ctx);
        return null;
    }

    private static void checkThreadAndEnqueue(final PacketTileStackWrapped message, final MessageContext ctx) {
        IThreadListener thread = ModCyclic.proxy.getThreadFromContext(ctx);
        thread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.func_130014_f_();
                TileEntity tile = world.func_175625_s(message.pos);
                if (tile != null && tile instanceof ITileStackWrapper) {
                    ((ITileStackWrapper)tile).setStackWrapper(message.index, message.stack);
                }
            }
        });
    }
}

