/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.block.ore.BlockDimensionOre;
import com.lothrazar.cyclicmagic.block.ore.WorldGenNewOre;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.util.UtilEntity;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import com.lothrazar.cyclicmagic.registry.BlockOreRegistry;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.ConfigRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class WorldModule
extends BaseEventModule
implements IHasConfig {
    static final int weightOre = 0;
    public static boolean netherOreEnabled;
    public static boolean endOreEnabled;
    public static boolean oreSpawns;
    public static boolean pigmenEnrage;
    public static List<BlockDimensionOre> ores;
    public static boolean enableModCompatOres;

    public WorldModule() {
        BlockOreRegistry.register();
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.world generation";
        config.setCategoryComment(category, "Control any blocks that get generated in new chunks & new worlds");
        Property prop = config.get(category, "Nether Ore", true, "Generate ore in the nether.");
        prop.setRequiresMcRestart(true);
        netherOreEnabled = prop.getBoolean();
        prop = config.get(category, "End Ore", true, "Generate ore in the end.");
        prop.setRequiresMcRestart(true);
        endOreEnabled = prop.getBoolean();
        prop = config.get(category, "Infested Ores", true, "These dimension ores (nether and end) have a chance to spawn endermites or silverfish");
        oreSpawns = prop.getBoolean();
        prop = config.get(category, "PigmenEnrage", false, "If true, mining Nether ore has a 20% chance of enraging a nearby PigZombie within 16 blocks");
        pigmenEnrage = prop.getBoolean();
        ConfigRegistry.oreConfig.load();
        enableModCompatOres = ConfigRegistry.oreConfig.getBoolean("globalOverride", "_global_", false, "False means all are disabled no matter what.  True means each ore uses its own true/false to exist.  ");
        for (BlockDimensionOre ore : ores) {
            Configuration oreConf = ore.config.isVanilla() ? config : ConfigRegistry.oreConfig;
            category = ore.config.getConfigCategory();
            ore.config.setBlockCount(oreConf.getInt(ore.config.getBlockCountConfig(), category, ore.config.getBlockCountDefault(), 0, 32, "Approximate ore vein size.  Zero means no spawns."));
            ore.config.setSpawnChance(oreConf.getInt(ore.config.getSpawnChanceConfig(), category, ore.config.getSpawnChanceDefault(), 0, 100, "Chance of a vein to spawn.  Zero means no spawns."));
            ore.config.setRegistered(oreConf.getBoolean(ore.config.getBlockId(), category, ore.config.isRegisteredDefault(), "Ore exists"));
            ore.config.setHarvestLevel(oreConf.getInt(ore.config.getBlockId() + "_harvest_level", category, ore.config.getHarvestLevelDefault(), 0, 3, "Tool Harvest Level"));
        }
        ConfigRegistry.oreConfig.save();
    }

    @Override
    public void onPreInit() {
        super.onPreInit();
        for (BlockDimensionOre ore : ores) {
            if (!ore.config.isVanilla() && !enableModCompatOres || ore.config.isVanilla() && ore.config.getDimension() == 1 && !endOreEnabled || ore.config.isVanilla() && ore.config.getDimension() == -1 && !netherOreEnabled || !ore.config.isRegistered()) continue;
            BlockRegistry.registerBlock((Block)ore, ore.config.getBlockId(), null);
            ore.setPickaxeHarvestLevel(ore.config.getHarvestLevel());
        }
    }

    @Override
    public void onInit() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenNewOre(), (int)0);
    }

    @SubscribeEvent
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getState() != null && event.getState().func_177230_c() instanceof BlockDimensionOre) {
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            if (oreSpawns) {
                BlockDimensionOre block = (BlockDimensionOre)event.getState().func_177230_c();
                block.trySpawnTriggeredEntity(world, pos);
            }
            if (pigmenEnrage && event.getWorld().field_73011_w.getDimension() == -1 && world.field_73012_v.nextDouble() < 0.2) {
                AxisAlignedBB range = UtilEntity.makeBoundingBox(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 3, 16);
                List found = world.func_72872_a(EntityPigZombie.class, range);
                for (EntityPigZombie pz : found) {
                    if (pz.func_175457_ck()) continue;
                    pz.func_70097_a(DamageSource.func_76365_a((EntityPlayer)event.getHarvester()), 0.0f);
                    break;
                }
            }
        }
    }

    static {
        oreSpawns = true;
        pigmenEnrage = true;
        ores = new ArrayList<BlockDimensionOre>();
    }
}

