/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.tiletransporter;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.item.BaseItem;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.core.util.UtilString;
import com.lothrazar.cyclicmagic.item.tiletransporter.PacketChestSack;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemChestSackEmpty
extends BaseItem
implements IHasRecipe,
IHasConfig {
    public static final String name = "chest_sack_empty";
    private static List<String> blacklistAll;
    private Item fullSack;

    public EnumActionResult func_180614_a(EntityPlayer entityPlayer, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (pos == null) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        if (state == null || tile == null) {
            UtilChat.sendStatusMessage(entityPlayer, "item.chest_sack_empty.inventory");
            return EnumActionResult.FAIL;
        }
        ResourceLocation blockId = state.func_177230_c().getRegistryName();
        if (UtilString.isInList(blacklistAll, blockId)) {
            UtilChat.sendStatusMessage(entityPlayer, "item.chest_sack_empty.blacklist");
            return EnumActionResult.FAIL;
        }
        UtilSound.playSound(entityPlayer, pos, SoundRegistry.chest_sack_capture);
        if (world.field_72995_K) {
            ModCyclic.network.sendToServer((IMessage)new PacketChestSack(pos));
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public IRecipe addRecipe() {
        RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " s ", "lbl", "lll", Character.valueOf('l'), "leather", Character.valueOf('b'), "slimeball", Character.valueOf('s'), "string");
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " s ", "lbl", "lll", Character.valueOf('l'), "leather", Character.valueOf('b'), new ItemStack(Items.field_151034_e), Character.valueOf('s'), "string");
    }

    public void setFullSack(Item item) {
        this.fullSack = item;
    }

    public Item getFullSack() {
        return this.fullSack;
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "modpacks";
        String[] deflist = new String[]{};
        Object[] blacklist = config.getStringList("SackHoldingBlacklist", category, deflist, "Containers that cannot be lifted up with the Empty Sack of Holding.  Use block id; for example minecraft:chest");
        blacklistAll = NonNullList.func_193580_a((Object)"", (Object[])blacklist);
    }
}

