/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.slingshot;

import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.item.BaseItemChargeScepter;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilOreDictionary;
import com.lothrazar.cyclicmagic.item.slingshot.EntitySlingshot;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemProjectileSlingshot
extends BaseItemChargeScepter
implements IHasRecipe {
    @GameRegistry.ObjectHolder(value="cyclicmagic:stone_pebble")
    public static final Item bullet = null;

    public ItemProjectileSlingshot() {
        super(1);
    }

    @Override
    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int chargeTimer) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        ItemStack itemstack = this.findAmmo(player);
        if (itemstack.func_190926_b()) {
            UtilChat.sendStatusMessage(player, "slingshot.ammoempty");
            return;
        }
        int charge = this.func_77626_a(stack) - chargeTimer;
        float percentageCharged = ItemBow.func_185059_b((int)charge);
        float amountCharged = percentageCharged * 9.7f;
        float velocityFactor = percentageCharged * 1.5f;
        float damage = MathHelper.func_76141_d((float)amountCharged) / 2;
        this.shootMain(world, player, velocityFactor, damage);
        itemstack.func_190918_g(1);
        BaseItemChargeScepter.ActionType type = BaseItemChargeScepter.ActionType.getAction(stack);
        if (!(type != BaseItemChargeScepter.ActionType.DOUBLE && type != BaseItemChargeScepter.ActionType.TRIPLE || itemstack.func_190926_b())) {
            this.shootMain(world, player, velocityFactor / 1.2f, damage);
            itemstack.func_190918_g(1);
        }
        if (type == BaseItemChargeScepter.ActionType.TRIPLE && !itemstack.func_190926_b()) {
            this.shootMain(world, player, velocityFactor / 1.5f, damage);
            itemstack.func_190918_g(1);
        }
    }

    protected boolean isAmmo(ItemStack stack) {
        return UtilOreDictionary.doesMatchOreDict(stack, "rock");
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public EntitySlingshot createBullet(World world, EntityPlayer player, float dmg) {
        return new EntitySlingshot(world, (EntityLivingBase)player);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Item)this), " bs", " fb", "b  ", Character.valueOf('s'), Items.field_151007_F, Character.valueOf('b'), new ItemStack(Items.field_151055_y), Character.valueOf('f'), new ItemStack(Items.field_151116_aA));
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.field_187797_fA;
    }
}

