/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.minecart;

import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.item.minecart.ItemGoldFurnaceMinecart;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityGoldFurnaceMinecart
extends EntityMinecart {
    public static ItemGoldFurnaceMinecart dropItem;
    private static final DataParameter<Boolean> POWERED;
    private int fuel;
    public double pushX;
    public double pushZ;

    public EntityGoldFurnaceMinecart(World worldIn) {
        super(worldIn);
        this.func_174899_a(this.func_180457_u());
    }

    public EntityGoldFurnaceMinecart(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.FURNACE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.fuel <= 0) {
            this.pushX = 0.0;
            this.pushZ = 0.0;
        } else {
            this.pushX = this.func_174898_m();
            this.pushZ = this.func_174898_m();
        }
        this.setMinecartPowered(this.fuel > 0);
        if (this.fuel > 0 && this.field_70146_Z.nextInt(4) == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected double func_174898_m() {
        return super.func_174898_m() + 0.5;
    }

    public float getMaxCartSpeedOnRail() {
        return super.getMaxCartSpeedOnRail() + 0.1f;
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack itemstack = new ItemStack((Item)dropItem);
            if (this.func_145818_k_()) {
                itemstack.func_151001_c(this.func_95999_t());
            }
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    public ItemStack getCartItem() {
        return new ItemStack((Item)dropItem);
    }

    protected void func_180460_a(BlockPos pos, IBlockState state) {
        super.func_180460_a(pos, state);
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (this.fuel > 0 && this.field_70159_w * this.field_70159_w < 0.001 && this.field_70179_y * this.field_70179_y < 0.001) {
            this.field_70159_w *= 2.0;
            this.field_70179_y *= 2.0;
            if (this.field_70159_w == 0.0 && this.field_70165_t - this.field_70169_q != 0.0) {
                this.field_70159_w = (this.field_70165_t - this.field_70169_q) * 8.0;
                this.pushX = (this.field_70165_t - this.field_70169_q) * (this.field_70165_t - this.field_70169_q);
                if (this.pushZ == 0.0) {
                    this.pushZ = 0.5;
                }
            }
            if (this.field_70179_y == 0.0 && this.field_70161_v - this.field_70166_s != 0.0) {
                this.field_70179_y = (this.field_70161_v - this.field_70166_s) * 8.0;
                this.pushZ = (this.field_70161_v - this.field_70166_s) * (this.field_70161_v - this.field_70166_s);
                if (this.pushX == 0.0) {
                    this.pushX = 0.5;
                }
            }
        }
        if (d0 > 1.0E-4) {
            d0 = MathHelper.func_76133_a((double)d0);
            if (this.pushX * this.field_70159_w + this.pushZ * this.field_70179_y < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                double d1 = d0 * this.func_174898_m();
                this.pushX *= d1;
                this.pushZ *= d1;
            }
        }
    }

    protected void func_94101_h() {
        if (this.fuel > 0) {
            return;
        }
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (d0 > 1.0E-4) {
            d0 = MathHelper.func_76133_a((double)d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            double d1 = 1.0;
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.8f;
            this.field_70159_w += this.pushX * d1;
            this.field_70179_y += this.pushZ * d1;
        } else {
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.98f;
        }
        super.func_94101_h();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player, hand))) {
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151044_h && this.fuel + 3600 <= 32000) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.fuel += 3600;
        }
        if (player.field_70170_p.field_72995_K) {
            UtilChat.addChatMessage(player, UtilChat.lang("minecart.fuel") + this.fuel);
        }
        return true;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74780_a("PushX", this.pushX);
        compound.func_74780_a("PushZ", this.pushZ);
        compound.func_74777_a("Fuel", (short)this.fuel);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.pushX = compound.func_74769_h("PushX");
        this.pushZ = compound.func_74769_h("PushZ");
        this.fuel = compound.func_74765_d("Fuel");
    }

    protected boolean isMinecartPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    protected void setMinecartPowered(boolean p_94107_1_) {
        this.field_70180_af.func_187227_b(POWERED, (Object)p_94107_1_);
    }

    public IBlockState func_180457_u() {
        return (this.isMinecartPowered() ? Blocks.field_150470_am : Blocks.field_150460_al).func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)EnumFacing.NORTH);
    }

    public void func_70108_f(Entity entityIn) {
        double motionXprev = this.field_70159_w;
        double motionZprev = this.field_70179_y;
        super.func_70108_f(entityIn);
        if (this.fuel > 0 && entityIn instanceof EntityMinecart && (this.field_70159_w != motionXprev || this.field_70179_y != motionZprev)) {
            this.field_70159_w = motionXprev * 8.0;
            this.field_70179_y = motionZprev * 8.0;
        }
    }

    static {
        POWERED = EntityDataManager.func_187226_a(EntityMinecartFurnace.class, (DataSerializer)DataSerializers.field_187198_h);
    }
}

