/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.findspawner;

import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.core.item.BaseItemProjectile;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilWorld;
import com.lothrazar.cyclicmagic.item.findspawner.EntityDungeonEye;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemProjectileDungeon
extends BaseItemProjectile
implements IHasRecipe,
IHasConfig {
    private static final int COOLDOWN = 10;
    private static int DUNGEONRADIUS = 64;

    public ItemProjectileDungeon() {
        this.func_77656_e(1000);
        this.func_77625_d(1);
    }

    @Override
    public EntityThrowableDispensable getThrownEntity(World world, ItemStack held, double x, double y, double z) {
        return new EntityDungeonEye(world, x, y, z);
    }

    @Override
    public void syncConfig(Configuration config) {
        DUNGEONRADIUS = config.getInt("Ender Dungeon Radius", "cyclicmagic.items", 64, 8, 128, "Search radius of dungeonfinder");
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Item)this), " sp", " ws", "w  ", Character.valueOf('w'), "cropNetherWart", Character.valueOf('s'), new ItemStack(Blocks.field_150341_Y), Character.valueOf('p'), "enderpearl");
    }

    @Override
    public void onItemThrow(ItemStack held, final World world, final EntityPlayer player, EnumHand hand) {
        player.func_184811_cZ().func_185145_a(held.func_77973_b(), 10);
        UtilItemStack.damageItem(player, held);
        final EntityDungeonEye entityendereye = new EntityDungeonEye(world, (EntityLivingBase)player);
        this.doThrow(world, player, hand, entityendereye, 0.5f);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (entityendereye == null || entityendereye.field_70128_L) {
                    return;
                }
                BlockPos blockpos = UtilWorld.findClosestBlock(player, Blocks.field_150474_ac, DUNGEONRADIUS);
                if (blockpos == null) {
                    entityendereye.kill();
                    if (world.field_72995_K) {
                        UtilChat.sendStatusMessage(player, UtilChat.lang("item.ender_dungeon.notfound") + " " + DUNGEONRADIUS);
                    }
                } else {
                    entityendereye.moveTowards(blockpos);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    @Override
    public SoundEvent getSound() {
        return SoundRegistry.dungeonfinder;
    }
}

