/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.equipbauble;

import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.item.BaseCharm;
import com.lothrazar.cyclicmagic.core.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemAutoTorch
extends BaseCharm
implements IHasRecipe,
IHasConfig {
    private static final int durability = 256;
    private static int lightLimit = 7;

    public ItemAutoTorch() {
        super(256);
        this.repairedBy = new ItemStack(Items.field_151044_h);
    }

    @Override
    public void onTick(ItemStack stack, EntityPlayer living) {
        if (!this.canTick(stack)) {
            return;
        }
        World world = living.field_70170_p;
        BlockPos pos = living.func_180425_c();
        if (world.func_175721_c(pos, true) < lightLimit && !living.func_175149_v() && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && world.func_175623_d(pos) && UtilPlaceBlocks.placeStateSafe(world, living, pos, Blocks.field_150478_aa.func_176223_P())) {
            super.damageCharm(living, stack);
        }
    }

    @Override
    public IRecipe addRecipe() {
        RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), new ItemStack((Item)this, 1, Short.MAX_VALUE), "blockCoal", "blockCoal", "blockCoal");
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "cic", " i ", "cic", Character.valueOf('c'), "blockCoal", Character.valueOf('i'), Blocks.field_150411_aY);
    }

    @Override
    public void syncConfig(Configuration config) {
        lightLimit = config.getInt("AutoTorchLightLevel", "modpacks", 7, 1, 14, "At which light level will auto torch place.  Set to 7 means it will place a torch 7 or darker.  (15 is full light, 0 is full dark)");
    }
}

