/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.enderbook;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.item.BaseItem;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilEntity;
import com.lothrazar.cyclicmagic.core.util.UtilNBT;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.core.util.UtilWorld;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderBook
extends BaseItem
implements IHasRecipe,
IHasConfig {
    public static String KEY_LOC = "location";
    public static String KEY_LARGEST = "loc_largest";
    public static int maximumSaved = 16;
    public static int expDistRatio = 10;
    public static final int BTNS_PER_COLUMN = 8;

    public ItemEnderBook() {
        this.func_77625_d(1);
    }

    public static ArrayList<BookLocation> getLocations(ItemStack itemStack) {
        ArrayList<BookLocation> list = new ArrayList<BookLocation>();
        int end = ItemEnderBook.getLargestSlot(itemStack);
        for (int i = 0; i <= end; ++i) {
            String KEY = KEY_LOC + "_" + i;
            String csv = UtilNBT.getItemStackNBT(itemStack).func_74779_i(KEY);
            if (csv == null || csv.isEmpty()) continue;
            list.add(new BookLocation(csv));
        }
        return list;
    }

    private static int getLocationsCount(ItemStack itemStack) {
        return ItemEnderBook.getLocations(itemStack).size();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(UtilChat.lang(this.getTooltip()) + ItemEnderBook.getLocationsCount(stack));
    }

    public static int getLargestSlot(ItemStack itemStack) {
        return UtilNBT.getItemStackNBT(itemStack).func_74762_e(KEY_LARGEST);
    }

    public static int getEmptySlotAndIncrement(ItemStack itemStack) {
        int empty = UtilNBT.getItemStackNBT(itemStack).func_74762_e(KEY_LARGEST);
        if (empty == 0) {
            empty = 1;
        }
        UtilNBT.getItemStackNBT(itemStack).func_74768_a(KEY_LARGEST, empty + 1);
        return empty;
    }

    public static ItemStack getPlayersBook(EntityPlayer player) {
        ItemStack book = player.func_184586_b(EnumHand.MAIN_HAND);
        if (book == null || !(book.func_77973_b() instanceof ItemEnderBook)) {
            book = player.func_184586_b(EnumHand.OFF_HAND);
        }
        UtilNBT.getItemStackNBT(book);
        return book;
    }

    public static void deleteWaypoint(EntityPlayer player, int slot) {
        ItemStack book = ItemEnderBook.getPlayersBook(player);
        book.func_77978_p().func_82580_o(KEY_LOC + "_" + slot);
    }

    public static void saveCurrentLocation(EntityPlayer player, String name) {
        ItemStack book = ItemEnderBook.getPlayersBook(player);
        int id = ItemEnderBook.getEmptySlotAndIncrement(book);
        BookLocation loc = new BookLocation(id, player, name);
        book.func_77978_p().func_74778_a(KEY_LOC + "_" + id, loc.toCSV());
    }

    private static BookLocation getLocation(ItemStack stack, int slot) {
        String csv = stack.func_77978_p().func_74779_i(KEY_LOC + "_" + slot);
        if (csv == null || csv.isEmpty()) {
            return null;
        }
        return new BookLocation(csv);
    }

    public static BlockPos getLocationPos(ItemStack stack, int slot) {
        BookLocation loc = ItemEnderBook.getLocation(stack, slot);
        if (loc == null) {
            return null;
        }
        return new BlockPos(loc.X, loc.Y, loc.Z);
    }

    public static boolean teleport(EntityPlayer player, int slot) {
        boolean success;
        ItemStack book = ItemEnderBook.getPlayersBook(player);
        String csv = book.func_77978_p().func_74779_i(KEY_LOC + "_" + slot);
        if (csv == null || csv.isEmpty()) {
            return false;
        }
        BookLocation loc = ItemEnderBook.getLocation(book, slot);
        if (player.field_71093_bK != loc.dimension) {
            return false;
        }
        UtilSound.playSound(player, SoundEvents.field_187544_ad);
        BlockPos dest = new BlockPos(loc.X, loc.Y, loc.Z);
        BlockPos start = player.func_180425_c();
        if (player instanceof EntityPlayerMP && (success = UtilEntity.enderTeleportEvent((EntityLivingBase)player, player.field_70170_p, loc.X, loc.Y + 0.1, loc.Z))) {
            player.func_130014_f_().func_175726_f(dest).func_177427_f(true);
            UtilSound.playSoundFromServer(SoundRegistry.warp, SoundCategory.PLAYERS, start, player.field_71093_bK, 32);
            UtilSound.playSoundFromServer(SoundRegistry.warp, SoundCategory.PLAYERS, dest, player.field_71093_bK, 32);
        }
        return true;
    }

    @Override
    public IRecipe addRecipe() {
        RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), new ItemStack((Item)this));
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "ene", "ebe", "eee", Character.valueOf('e'), "enderpearl", Character.valueOf('b'), Items.field_151122_aG, Character.valueOf('n'), "blockEmerald");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityPlayer, EnumHand hand) {
        ItemStack stack = entityPlayer.func_184586_b(hand);
        if (stack == null || stack.func_77973_b() == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        entityPlayer.openGui((Object)ModCyclic.instance, 4, world, 0, 0, 0);
        return super.func_77659_a(world, entityPlayer, hand);
    }

    public static int getExpCostPerTeleport(EntityPlayer player, ItemStack book, int slot) {
        if (expDistRatio <= 0) {
            return 0;
        }
        BlockPos toPos = ItemEnderBook.getLocationPos(book, slot);
        int distance = (int)UtilWorld.distanceBetweenHorizontal(toPos, player.func_180425_c());
        return Math.round(distance / expDistRatio);
    }

    @Override
    public void syncConfig(Configuration config) {
        maximumSaved = config.getInt("EnderBookMaxSaved", "modpacks", 16, 1, 64, "Maximum number of saved waypoints in the ender book.  It still uses 8 per column, and putting too many may send it offscreen");
        expDistRatio = config.getInt("EnderBookExpCostRatio", "modpacks", 10, 0, 100, "The exp cost of teleporting is [the horizontal distance] divided by [this number] rounded to the nearest integer.  For example, if this number is 10, then teleporting 20 blocks costs 2 exp");
    }

    public static class BookLocation {
        public double X;
        public double Y;
        public double Z;
        public int id;
        public int dimension;
        public String display;

        public BookLocation(int idx, EntityPlayer p, String d) {
            this.X = p.field_70165_t;
            this.Y = p.field_70163_u;
            this.Z = p.field_70161_v;
            this.id = idx;
            this.dimension = p.field_71093_bK;
            this.display = d;
        }

        public BookLocation(String csv) {
            String[] pts = csv.split(",");
            this.id = Integer.parseInt(pts[0]);
            this.X = Double.parseDouble(pts[1]);
            this.Y = Double.parseDouble(pts[2]);
            this.Z = Double.parseDouble(pts[3]);
            this.dimension = Integer.parseInt(pts[4]);
            if (pts.length > 5) {
                this.display = pts[5];
            }
        }

        public String toCSV() {
            return this.id + "," + this.X + "," + this.Y + "," + this.Z + "," + this.dimension + "," + this.display;
        }

        public BlockPos toBlockPos() {
            return new BlockPos(this.X, this.Y, this.Z);
        }

        public String coordsDisplay() {
            return Math.round(this.X) + ", " + Math.round(this.Y) + ", " + Math.round(this.Z);
        }

        public String toString() {
            return this.toCSV() + " : " + this.display;
        }
    }
}

