/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.item.BaseTool;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilNBT;
import com.lothrazar.cyclicmagic.core.util.UtilShape;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWaterRemoval
extends BaseTool
implements IHasRecipe {
    private static final int HEIGHT = 3;
    private static final int RADIUS = 4;

    public ItemWaterRemoval() {
        super(9000);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        List<BlockPos> shape = UtilShape.cubeFilled(playerIn.func_180425_c().func_177977_b(), 4, 3);
        ArrayList queuedToUpdate = new ArrayList();
        int success = 0;
        for (BlockPos pos : shape) {
            if (!this.isValidForMode(stack, worldIn.func_180495_p(pos)) || !worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2)) continue;
            ++success;
        }
        if (success > 0) {
            UtilItemStack.damageItem(playerIn, playerIn.func_184586_b(hand), success);
            UtilSound.playSound(playerIn, SoundRegistry.liquid_evaporate);
            playerIn.func_184609_a(hand);
            for (BlockPos blockpos2 : queuedToUpdate) {
                worldIn.func_175685_c(blockpos2, Blocks.field_150350_a, false);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private boolean isValidForMode(ItemStack held, IBlockState state) {
        switch (ActionType.getAction(held)) {
            case GENERIC: {
                return state.func_185904_a() == Material.field_151586_h || state.func_185904_a() == Material.field_151587_i;
            }
            case WATER: {
                return state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i;
            }
            case LAVA: {
                return state.func_177230_c() == Blocks.field_150353_l || state.func_177230_c() == Blocks.field_150356_k;
            }
        }
        return false;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Item)this), "iii", " c ", "bcb", Character.valueOf('b'), Items.field_151102_aT, Character.valueOf('c'), Blocks.field_150360_v, Character.valueOf('i'), "dyeBlue");
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held.func_77973_b() == this) {
            if (ActionType.getTimeout(held) > 0) {
                return;
            }
            ActionType.setTimeout(held);
            event.setCanceled(true);
            UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.tool_mode, SoundCategory.PLAYERS, 0.1f);
            if (!player.func_130014_f_().field_72995_K) {
                ActionType.toggle(held);
                UtilChat.addChatMessage(player, UtilChat.lang(ActionType.getName(held)));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + UtilChat.lang(ActionType.getName(stack)));
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        ActionType.tickTimeout(stack);
    }

    public static enum ActionType {
        WATER,
        LAVA,
        GENERIC;

        private static final String NBT = "ActionType";
        private static final String NBTTIMEOUT = "timeout";

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT) + 1;
            if (type >= ActionType.values().length) {
                type = 0;
            }
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
        }

        public static ActionType getAction(ItemStack wand) {
            try {
                NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
                return ActionType.values()[tags.func_74762_e(NBT)];
            }
            catch (Exception e) {
                return WATER;
            }
        }

        public static String getName(ItemStack wand) {
            return "wand.liquid." + ActionType.getAction(wand).toString().toLowerCase();
        }

        public static void setTimeout(ItemStack wand) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
        }

        public static int getTimeout(ItemStack wand) {
            return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
        }

        public static void tickTimeout(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int t = tags.func_74762_e(NBTTIMEOUT);
            if (t > 0) {
                UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
            }
        }
    }
}

