/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.enchant;

import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.enchant.EnchantBase;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantExcavation
extends EnchantBase
implements IHasConfig {
    int[] levelToMaxBreak;

    public EnchantExcavation() {
        super("excavation", Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        GuideRegistry.register(this, new ArrayList<String>());
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        if (player.field_184622_au == null) {
            return;
        }
        BlockPos pos = event.getPos();
        Block block = event.getState().func_177230_c();
        ItemStack stackHarvestingWith = player.func_184586_b(player.field_184622_au);
        int level = this.getCurrentLevelTool(stackHarvestingWith);
        if (level <= 0) {
            return;
        }
        boolean isAnySingleOk = false;
        for (String type : stackHarvestingWith.func_77973_b().getToolClasses(stackHarvestingWith)) {
            if (!block.isToolEffective(type, world.func_180495_p(pos))) continue;
            isAnySingleOk = true;
        }
        if (isAnySingleOk) {
            this.harvestSurrounding(world, player, pos, block, 1, level);
        }
    }

    private int getHarvestMax(int level) {
        return this.levelToMaxBreak[level];
    }

    private void harvestSurrounding(World world, EntityPlayer player, BlockPos posIn, Block block, int totalBroken, int level) {
        if (totalBroken > this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b()) {
            return;
        }
        int fortuneXp = 0;
        List<BlockPos> theFuture = this.getMatchingSurrounding(world, posIn, block);
        ArrayList<BlockPos> wasHarvested = new ArrayList<BlockPos>();
        for (BlockPos targetPos : theFuture) {
            IBlockState targetState = world.func_180495_p(targetPos);
            if (world.func_175623_d(targetPos) || !player.func_184823_b(targetState)) continue;
            block.func_180657_a(world, player, targetPos, targetState, null, player.func_184586_b(EnumHand.MAIN_HAND));
            block.func_180637_b(world, targetPos, block.getExpDrop(targetState, (IBlockAccess)world, targetPos, fortuneXp));
            world.func_175655_b(targetPos, false);
            wasHarvested.add(targetPos);
            player.func_184586_b(player.field_184622_au).func_96631_a(1, world.field_73012_v, null);
            this.harvestSurrounding(world, player, targetPos, block, ++totalBroken, level);
        }
    }

    private List<BlockPos> getMatchingSurrounding(World world, BlockPos start, Block blockIn) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        List<EnumFacing> targetFaces = Arrays.asList(EnumFacing.values());
        Collections.shuffle(targetFaces);
        for (EnumFacing fac : targetFaces) {
            if (world.func_180495_p(start.func_177972_a(fac)).func_177230_c() != blockIn) continue;
            list.add(start.func_177972_a(fac));
        }
        return list;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.levelToMaxBreak = new int[this.func_77325_b() + 1];
        this.levelToMaxBreak[0] = 0;
        for (int i = 1; i <= this.func_77325_b(); ++i) {
            this.levelToMaxBreak[i] = config.getInt("EnchantExcavationBreak" + i, "modpacks", 10 + i * 12, 1, 128, "Max blocks broken by this enchantment at level " + i);
        }
    }
}

