/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.core.util;

import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilPlayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class UtilInventoryTransfer {
    public static void dumpFromPlayerToIInventory(World world, IInventory inventory, EntityPlayer player) {
        int start;
        block0: for (int islotInvo = start = 0; islotInvo < inventory.func_70302_i_(); ++islotInvo) {
            ItemStack chestEmptySlot = inventory.func_70301_a(islotInvo);
            if (!chestEmptySlot.func_190926_b()) continue;
            for (int islotPlayer = 9; islotPlayer < UtilInventoryTransfer.getInvoEnd(player); ++islotPlayer) {
                ItemStack playerItem = player.field_71071_by.func_70301_a(islotPlayer);
                if (playerItem.func_190926_b()) continue;
                inventory.func_70299_a(islotInvo, playerItem);
                player.field_71071_by.func_70299_a(islotPlayer, ItemStack.field_190927_a);
                continue block0;
            }
        }
        UtilPlayer.updatePlayerContainerClient(player);
    }

    public static void dumpFromIInventoryToPlayer(World world, IInventory inventory, EntityPlayer player) {
        int start = 0;
        block0: for (int islotPlayer = 9; islotPlayer < UtilInventoryTransfer.getInvoEnd(player); ++islotPlayer) {
            ItemStack playerEmptySlot = player.field_71071_by.func_70301_a(islotPlayer);
            if (!playerEmptySlot.func_190926_b()) continue;
            for (int islotInvo = start; islotInvo < inventory.func_70302_i_(); ++islotInvo) {
                ItemStack chestItem = inventory.func_70301_a(islotInvo);
                if (chestItem.func_190926_b()) continue;
                player.field_71071_by.func_70299_a(islotPlayer, chestItem);
                inventory.func_70299_a(islotInvo, ItemStack.field_190927_a);
                start = islotInvo + 1;
                continue block0;
            }
        }
        UtilPlayer.updatePlayerContainerClient(player);
    }

    public static void sortFromPlayerToInventory(World world, IInventory chest, EntityPlayer player) {
        int START_CHEST = 0;
        int END_CHEST = chest.func_70302_i_();
        for (int islotChest = START_CHEST; islotChest < END_CHEST; ++islotChest) {
            ItemStack chestItem = chest.func_70301_a(islotChest);
            if (chestItem.func_190926_b()) continue;
            for (int islotInv = 9; islotInv < UtilInventoryTransfer.getInvoEnd(player); ++islotInv) {
                int chestMax;
                int room;
                ItemStack playerItem = player.field_71071_by.func_70301_a(islotInv);
                if (playerItem.func_190926_b() || !UtilItemStack.canMerge(playerItem, chestItem) || (room = (chestMax = chestItem.func_77973_b().getItemStackLimit(chestItem)) - chestItem.func_190916_E()) <= 0) continue;
                int toDeposit = Math.min(playerItem.func_190916_E(), room);
                chestItem.func_190917_f(toDeposit);
                chest.func_70299_a(islotChest, chestItem);
                playerItem.func_190918_g(toDeposit);
                if (playerItem.func_190916_E() <= 0) {
                    player.field_71071_by.func_70299_a(islotInv, ItemStack.field_190927_a);
                    continue;
                }
                player.field_71071_by.func_70299_a(islotInv, playerItem);
            }
        }
        UtilPlayer.updatePlayerContainerClient(player);
    }

    public static void sortFromInventoryToPlayer(World world, IInventory chest, EntityPlayer player, boolean restockLeaveOne) {
        int START_CHEST = 0;
        int END_CHEST = chest.func_70302_i_();
        for (int islotChest = START_CHEST; islotChest < END_CHEST; ++islotChest) {
            ItemStack chestItem = chest.func_70301_a(islotChest);
            if (chestItem.func_190926_b()) continue;
            for (int islotInv = 9; islotInv < UtilInventoryTransfer.getInvoEnd(player); ++islotInv) {
                int invMax;
                int room;
                ItemStack playerItem = player.field_71071_by.func_70301_a(islotInv);
                if (playerItem.func_190926_b() || !UtilItemStack.canMerge(playerItem, chestItem) || (room = (invMax = playerItem.func_77973_b().getItemStackLimit(playerItem)) - playerItem.func_190916_E()) <= 0) continue;
                int toDeposit = Math.min(chestItem.func_190916_E(), room);
                if (restockLeaveOne && chestItem.func_190916_E() - toDeposit == 0 && --toDeposit == 0) continue;
                playerItem.func_190917_f(toDeposit);
                player.field_71071_by.func_70299_a(islotInv, playerItem);
                chestItem.func_190918_g(toDeposit);
                if (chestItem.func_190916_E() <= 0) {
                    chest.func_70299_a(islotChest, ItemStack.field_190927_a);
                    continue;
                }
                chest.func_70299_a(islotChest, chestItem);
            }
        }
        UtilPlayer.updatePlayerContainerClient(player);
    }

    private static int getInvoEnd(EntityPlayer p) {
        return p.field_71071_by.func_70302_i_() - 4 - 1;
    }

    public static ArrayList<ItemStack> dumpToIInventory(List<ItemStack> stacks, IInventory inventory, int startingSlot, int maxSlot) {
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (ItemStack current : stacks) {
            for (int i = startingSlot; i < maxSlot; ++i) {
                int space;
                int toDeposit;
                if (current.func_190926_b()) continue;
                ItemStack chestStack = inventory.func_70301_a(i);
                if (chestStack.func_190926_b()) {
                    inventory.func_70299_a(i, current);
                    current = ItemStack.field_190927_a;
                    continue;
                }
                if (!UtilItemStack.canMerge(chestStack, current) || (toDeposit = Math.min(space = chestStack.func_77976_d() - chestStack.func_190916_E(), current.func_190916_E())) <= 0) continue;
                current.func_190918_g(toDeposit);
                chestStack.func_190917_f(toDeposit);
                if (current.func_190916_E() != 0) continue;
                current = ItemStack.field_190927_a;
            }
            if (current.func_190926_b()) continue;
            remaining.add(current);
        }
        return remaining;
    }

    public static ArrayList<ItemStack> dumpToIInventory(List<ItemStack> stacks, IInventory inventory, int startingSlot) {
        return UtilInventoryTransfer.dumpToIInventory(stacks, inventory, startingSlot, inventory.func_70302_i_());
    }

    public static BagDepositReturn dumpFromListToIInventory(World world, IInventory chest, NonNullList<ItemStack> stacks, boolean onlyMatchingItems) {
        int itemsMoved = 0;
        block0: for (int islotStacks = 0; islotStacks < stacks.size(); ++islotStacks) {
            ItemStack bagItem = (ItemStack)stacks.get(islotStacks);
            if (bagItem.func_190926_b() || bagItem.func_190916_E() == 0) continue;
            for (int islotChest = 0; islotChest < chest.func_70302_i_(); ++islotChest) {
                ItemStack chestItem = chest.func_70301_a(islotChest);
                if (chestItem.func_190926_b() && !onlyMatchingItems) {
                    if (!chest.func_94041_b(islotStacks, bagItem)) continue;
                    itemsMoved += bagItem.func_190916_E();
                    chest.func_70299_a(islotChest, bagItem);
                    stacks.set(islotStacks, (Object)ItemStack.field_190927_a);
                    bagItem = ItemStack.field_190927_a;
                    continue block0;
                }
                if (chestItem.func_190926_b()) continue;
                if (UtilItemStack.isEmpty(bagItem)) continue block0;
                bagItem = (ItemStack)stacks.get(islotStacks);
                if (UtilItemStack.canMerge(bagItem, chestItem)) {
                    int chestMax = chestItem.func_77973_b().getItemStackLimit(chestItem);
                    int room = chestMax - chestItem.func_190916_E();
                    if (room <= 0) continue;
                    int toDeposit = Math.min(bagItem.func_190916_E(), room);
                    chestItem.func_190917_f(toDeposit);
                    chest.func_70299_a(islotChest, chestItem);
                    bagItem.func_190918_g(toDeposit);
                    itemsMoved += toDeposit;
                    if (bagItem.func_190916_E() <= 0) {
                        stacks.set(islotStacks, (Object)ItemStack.field_190927_a);
                    } else {
                        stacks.set(islotStacks, (Object)bagItem);
                    }
                }
                if (UtilItemStack.isEmpty(bagItem)) continue block0;
            }
        }
        return new BagDepositReturn(itemsMoved, stacks);
    }

    public static class BagDepositReturn {
        public int moved;
        public NonNullList<ItemStack> stacks;

        public BagDepositReturn(int m, NonNullList<ItemStack> s) {
            this.moved = m;
            this.stacks = s;
        }
    }
}

