/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class UtilGenerateRecipeJson {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File RECIPE_DIR = new File("Q:/CODE/minecraft/eclipseWorkspace/cyclic/src/main/resources/assets/cyclicmagic/recipes");

    public static void addShapedRecipe(ItemStack result, Object ... components) {
        int i;
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add((String)components[i]);
        }
        json.put("pattern", pattern);
        boolean isOreDict = false;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object o = components[i];
            if (o instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)o;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (o instanceof String) {
                    isOreDict = true;
                }
                key.put(Character.toString(curKey.charValue()), UtilGenerateRecipeJson.serializeItem(o));
                curKey = null;
            }
            ++i;
        }
        json.put("key", key);
        json.put("type", isOreDict ? "forge:ore_shaped" : "minecraft:crafting_shaped");
        json.put("result", UtilGenerateRecipeJson.serializeItem(result));
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapelessRecipe(ItemStack result, Object ... components) {
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object o : components) {
            if (o instanceof String) {
                isOreDict = true;
            }
            ingredients.add(UtilGenerateRecipeJson.serializeItem(o));
        }
        json.put("ingredients", ingredients);
        json.put("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
        json.put("result", UtilGenerateRecipeJson.serializeItem(result));
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Object> serializeItem(Object thing) {
        if (thing instanceof Item) {
            return UtilGenerateRecipeJson.serializeItem(new ItemStack((Item)thing));
        }
        if (thing instanceof Block) {
            return UtilGenerateRecipeJson.serializeItem(new ItemStack((Block)thing));
        }
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                throw new IllegalArgumentException("Too lazy to implement nbt support rn");
            }
            return ret;
        }
        if (thing instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("type", "forge:ore_dict");
            ret.put("ore", thing);
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name : " + thing);
    }
}

