/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.core.liquid;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.tank.TileEntityFluidTank;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketFluidSync
implements IMessage,
IMessageHandler<PacketFluidSync, IMessage> {
    private BlockPos pos;
    public FluidStack fluid;

    public PacketFluidSync() {
    }

    public PacketFluidSync(BlockPos p, FluidStack fluid) {
        this.pos = p;
        this.fluid = fluid;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags);
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        if (this.fluid != null) {
            this.fluid.writeToNBT(tags);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketFluidSync message, MessageContext ctx) {
        TileEntity te;
        EntityPlayer p;
        if (ctx.side == Side.CLIENT && (p = ModCyclic.proxy.getPlayerEntity(ctx)) != null && (te = p.field_70170_p.func_175625_s(message.pos)) instanceof TileEntityFluidTank) {
            ((TileEntityFluidTank)te).updateFluidTo(message.fluid);
        }
        return null;
    }
}

