/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.core.item;

import com.lothrazar.cyclicmagic.core.item.BaseTool;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class BaseItemRapidScepter
extends BaseTool {
    private static final float VELOCITY_MAX = 1.5f;
    private static final float INACCURACY_DEFAULT = 1.0f;
    private static final float PITCHOFFSET = 0.0f;
    private static final float MAX_CHARGE = 9.7f;

    public BaseItemRapidScepter(int durability) {
        super(durability);
    }

    public abstract SoundEvent getSound();

    public abstract EntityThrowable createBullet(World var1, EntityPlayer var2, float var3);

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        float amountCharged = 9.7f;
        float damage = MathHelper.func_76141_d((float)amountCharged) / 2;
        int shots = 0;
        double rand = world.field_73012_v.nextDouble();
        if (rand < 0.2) {
            this.shootMain(world, player, 1.5f, damage);
            this.shootTwins(world, player, 1.5f, damage);
        } else if (rand < 0.75) {
            this.shootMain(world, player, 1.5f, damage);
        } else {
            this.shootTwins(world, player, 1.5f, damage);
        }
        UtilItemStack.damageItem(player, stack, shots);
        super.onUse(stack, player, world, EnumHand.MAIN_HAND);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private void shootMain(World world, EntityPlayer player, float velocityFactor, float damage) {
        EntityThrowable proj = this.createBullet(world, player, damage);
        this.launchProjectile(world, player, proj, velocityFactor);
    }

    private void shootTwins(World world, EntityPlayer player, float velocityFactor, float damage) {
        Vec3d vecCrossRight = player.func_70040_Z().func_72432_b().func_72431_c(new Vec3d(0.0, 2.0, 0.0));
        Vec3d vecCrossLeft = player.func_70040_Z().func_72432_b().func_72431_c(new Vec3d(0.0, -2.0, 0.0));
        EntityThrowable projRight = this.createBullet(world, player, damage);
        projRight.field_70165_t += vecCrossRight.field_72450_a;
        projRight.field_70161_v += vecCrossRight.field_72449_c;
        this.launchProjectile(world, player, projRight, velocityFactor);
        EntityThrowable projLeft = this.createBullet(world, player, damage);
        projLeft.field_70165_t += vecCrossLeft.field_72450_a;
        projLeft.field_70161_v += vecCrossLeft.field_72449_c;
        this.launchProjectile(world, player, projLeft, velocityFactor);
    }

    protected void launchProjectile(World world, EntityPlayer player, EntityThrowable thing, float velocity) {
        if (!world.field_72995_K) {
            thing.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity, 1.0f);
            world.func_72838_d((Entity)thing);
        }
        BlockPos pos = player.func_180425_c();
        UtilSound.playSound(player, pos, this.getSound(), SoundCategory.PLAYERS);
    }
}

