/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.screen;

import com.lothrazar.cyclicmagic.core.ITileTextbox;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineInvo;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityScreen
extends TileEntityBaseMachineInvo
implements ITileTextbox {
    private String text = "";
    private int red = 100;
    private int green = 100;
    private int blue = 100;
    private int cursorPos = 0;
    private int padding = 0;
    private Justification justif = Justification.LEFT;

    public TileEntityScreen() {
        super(0);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String s) {
        this.text = s;
    }

    public int getPadding() {
        return this.padding;
    }

    public int getColor() {
        return (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | (this.blue & 0xFF) << 0;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.text = tags.func_74779_i("text");
        this.red = tags.func_74762_e("red");
        this.green = tags.func_74762_e("green");
        this.blue = tags.func_74762_e("blue");
        this.cursorPos = tags.func_74762_e("cursorPos");
        this.padding = tags.func_74762_e("padding");
        int just = tags.func_74762_e("justif");
        if (just < Justification.values().length) {
            this.justif = Justification.values()[just];
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74778_a("text", this.text);
        tags.func_74768_a("red", this.red);
        tags.func_74768_a("green", this.green);
        tags.func_74768_a("blue", this.blue);
        tags.func_74768_a("cursorPos", this.cursorPos);
        tags.func_74768_a("padding", this.padding);
        tags.func_74768_a("justif", this.justif.ordinal());
        return super.func_189515_b(tags);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case BLUE: {
                return this.blue;
            }
            case GREEN: {
                return this.green;
            }
            case RED: {
                return this.red;
            }
            case CURSORPOS: {
                return this.cursorPos;
            }
            case JUSTIFICATION: {
                return this.justif.ordinal();
            }
            case PADDING: {
                return this.padding;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case BLUE: {
                this.blue = value;
                break;
            }
            case GREEN: {
                this.green = value;
                break;
            }
            case RED: {
                this.red = value;
                break;
            }
            case CURSORPOS: {
                this.cursorPos = value;
                break;
            }
            case JUSTIFICATION: {
                int val = value % Justification.values().length;
                this.justif = Justification.values()[val];
                break;
            }
            case PADDING: {
                this.padding = value;
            }
        }
    }

    public Justification getJustification() {
        return this.justif;
    }

    public static enum Fields {
        RED,
        GREEN,
        BLUE,
        CURSORPOS,
        JUSTIFICATION,
        PADDING;

    }

    public static enum Justification {
        LEFT,
        CENTER,
        RIGHT;

    }
}

