/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.peat;

import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBase;
import com.lothrazar.cyclicmagic.core.util.UtilParticle;
import com.lothrazar.cyclicmagic.core.util.UtilShape;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockPeat
extends BlockBase
implements IHasRecipe {
    private static final double CHANCE_BAKE_PCT = 0.05;
    private boolean isBaked;
    private Item drop;

    public BlockPeat(Item drop) {
        super(Material.field_151578_c);
        this.func_149672_a(SoundType.field_185849_b);
        this.setHarvestLevel("shovel", 2);
        this.func_149675_a(true);
        this.isBaked = drop != null;
        this.drop = drop;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.isBaked) {
            return this.drop;
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int func_149745_a(Random rand) {
        if (this.isBaked) {
            return 1 + rand.nextInt(2);
        }
        return 1;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.isBaked) {
            return;
        }
        List<BlockPos> around = UtilShape.squareHorizontalHollow(pos, 1);
        for (BlockPos p : around) {
            Block bSide = world.func_180495_p(p).func_177230_c();
            if (bSide != Blocks.field_150355_j) continue;
            this.tryBake(world, pos);
            return;
        }
    }

    private void tryBake(World world, BlockPos pos) {
        if (!this.isBaked && world.field_73012_v.nextDouble() < 0.05) {
            world.func_175698_g(pos);
            world.func_175656_a(pos, Block.func_149684_b((String)"cyclicmagic:peat_baked").func_176223_P());
            UtilParticle.spawnParticle(world, EnumParticleTypes.WATER_BUBBLE, pos);
        }
    }

    public int func_149738_a(World worldIn) {
        return 1100;
    }

    @Override
    public IRecipe addRecipe() {
        if (this.isBaked) {
            return null;
        }
        RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 16), "pcp", "cbc", "pcp", Character.valueOf('b'), new ItemStack(Item.func_111206_d((String)"cyclicmagic:peat_biomass")), Character.valueOf('c'), "dirt", Character.valueOf('p'), new ItemStack(Item.func_111206_d((String)"cyclicmagic:peat_fuel")));
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 4), "pcp", "c c", "pcp", Character.valueOf('c'), "dirt", Character.valueOf('p'), new ItemStack(Item.func_111206_d((String)"cyclicmagic:peat_biomass")));
    }
}

