/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.miner;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.core.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class TileEntityBlockMiner
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    private static final String NBT_REDST = "redstone";
    private UUID uuid;
    private boolean isCurrentlyMining;
    private WeakReference<FakePlayer> fakePlayer;
    private float curBlockDamage;
    private int needsRedstone = 1;
    private BlockPos targetPos = null;
    private static final String NBTMINING = "mining";
    private static final String NBTDAMAGE = "curBlockDamage";
    private static final String NBTPLAYERID = "uuid";
    private static final String NBTTARGET = "target";

    public TileEntityBlockMiner() {
        super(0);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        World world;
        if (this.isRunning()) {
            this.spawnParticlesAbove();
        }
        if ((world = this.func_145831_w()) instanceof WorldServer) {
            this.verifyUuid(world);
            if (this.fakePlayer == null) {
                this.fakePlayer = UtilFakePlayer.initFakePlayer((WorldServer)world, this.uuid, "block_miner");
                if (this.fakePlayer == null) {
                    ModCyclic.logger.error("Fake player failed to init ");
                    return;
                }
            }
            this.tryEquipItem();
            BlockPos start = this.field_174879_c.func_177972_a(this.getCurrentFacing());
            if (this.targetPos == null) {
                this.targetPos = start;
            }
            if (this.isRunning()) {
                if (!this.isCurrentlyMining) {
                    if (!world.func_175623_d(this.targetPos)) {
                        this.isCurrentlyMining = true;
                        this.curBlockDamage = 0.0f;
                    } else {
                        this.isCurrentlyMining = false;
                        this.resetProgress(this.targetPos);
                    }
                }
            } else if (this.isCurrentlyMining) {
                this.isCurrentlyMining = false;
                this.resetProgress(this.targetPos);
            }
            if (this.isCurrentlyMining) {
                IBlockState targetState = world.func_180495_p(this.targetPos);
                this.curBlockDamage += UtilItemStack.getPlayerRelativeBlockHardness(targetState.func_177230_c(), targetState, (EntityPlayer)this.fakePlayer.get(), world, this.targetPos);
                if (this.curBlockDamage >= 1.0f) {
                    this.isCurrentlyMining = false;
                    this.resetProgress(this.targetPos);
                    if (this.fakePlayer != null && this.fakePlayer.get() != null) {
                        ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_180237_b(this.targetPos);
                    }
                } else {
                    world.func_175715_c(this.uuid.hashCode(), this.targetPos, (int)(this.curBlockDamage * 10.0f) - 1);
                }
            }
        }
    }

    private void verifyUuid(World world) {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            IBlockState state = world.func_180495_p(this.field_174879_c);
            world.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private void tryEquipItem() {
        if (((FakePlayer)this.fakePlayer.get()).func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            ItemStack unbreakingPickaxe = new ItemStack(Items.field_151046_w, 1);
            unbreakingPickaxe.func_77966_a(Enchantments.field_185305_q, 3);
            unbreakingPickaxe.func_77982_d(new NBTTagCompound());
            unbreakingPickaxe.func_77978_p().func_74757_a("Unbreakable", true);
            ((FakePlayer)this.fakePlayer.get()).func_184201_a(EntityEquipmentSlot.MAINHAND, unbreakingPickaxe);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_REDST, this.needsRedstone);
        if (this.uuid != null) {
            tagCompound.func_74778_a(NBTPLAYERID, this.uuid.toString());
        }
        if (this.targetPos != null) {
            tagCompound.func_74783_a(NBTTARGET, new int[]{this.targetPos.func_177958_n(), this.targetPos.func_177956_o(), this.targetPos.func_177952_p()});
        }
        tagCompound.func_74757_a(NBTMINING, this.isCurrentlyMining);
        tagCompound.func_74776_a(NBTDAMAGE, this.curBlockDamage);
        return super.func_189515_b(tagCompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        int[] coords;
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e(NBT_REDST);
        if (tagCompound.func_74764_b(NBTPLAYERID)) {
            this.uuid = UUID.fromString(tagCompound.func_74779_i(NBTPLAYERID));
        }
        if (tagCompound.func_74764_b(NBTTARGET) && (coords = tagCompound.func_74759_k(NBTTARGET)).length >= 3) {
            this.targetPos = new BlockPos(coords[0], coords[1], coords[2]);
        }
        this.isCurrentlyMining = tagCompound.func_74767_n(NBTMINING);
        this.curBlockDamage = tagCompound.func_74760_g(NBTDAMAGE);
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isCurrentlyMining && this.uuid != null) {
            this.resetProgress(pos);
        }
    }

    private void resetProgress(BlockPos targetPos) {
        if (this.uuid != null) {
            this.func_145831_w().func_175715_c(this.uuid.hashCode(), targetPos, -1);
            this.curBlockDamage = 0.0f;
        }
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case REDSTONE: {
                    return this.needsRedstone;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case REDSTONE: {
                    this.needsRedstone = value;
                }
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        REDSTONE;

    }
}

