/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.fishing;

import com.lothrazar.cyclicmagic.block.fishing.BlockFishing;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilParticle;
import com.lothrazar.cyclicmagic.core.util.UtilShape;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityFishing
extends TileEntityBaseMachineInvo
implements ITickable,
ITileRedstoneToggle {
    private static final int ENERGY_PER_FISH = 100;
    public static final int FISHSLOTS = 15;
    public static final int MINIMUM_WET_SIDES = 1;
    public static final float SPEEDFACTOR = 8.9E-4f;
    static final int SLOT_TOOL = 0;
    public ArrayList<Block> waterBoth = new ArrayList();
    private int needsRedstone = 1;

    public TileEntityFishing() {
        super(16);
        this.initEnergy(BlockFishing.FUEL_COST);
        this.waterBoth.add((Block)Blocks.field_150358_i);
        this.waterBoth.add((Block)Blocks.field_150355_j);
        this.setSlotsForInsert(0);
        this.setSlotsForExtract(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15));
    }

    public boolean isValidPosition() {
        return this.countWetSides() >= 1;
    }

    public int countWetSides() {
        int cov = 0;
        List<BlockPos> areas = Arrays.asList(this.field_174879_c.func_177977_b(), this.field_174879_c.func_177978_c(), this.field_174879_c.func_177974_f(), this.field_174879_c.func_177976_e(), this.field_174879_c.func_177968_d(), this.field_174879_c.func_177984_a());
        World world = this.func_145831_w();
        for (BlockPos adj : areas) {
            if (!this.waterBoth.contains(world.func_180495_p(adj).func_177230_c())) continue;
            ++cov;
        }
        return cov;
    }

    public int countWaterFlowing() {
        int cov = 0;
        List<BlockPos> areas = this.getWaterArea();
        World world = this.func_145831_w();
        for (BlockPos adj : areas) {
            if (world.func_180495_p(adj).func_177230_c() != Blocks.field_150358_i) continue;
            ++cov;
        }
        return cov;
    }

    private List<BlockPos> getWaterArea() {
        return UtilShape.cubeFilled(this.func_174877_v().func_177979_c(2), 2, 2);
    }

    public int countWater() {
        int cov = 0;
        List<BlockPos> areas = this.getWaterArea();
        World world = this.func_145831_w();
        for (BlockPos adj : areas) {
            if (world.func_180495_p(adj).func_177230_c() != Blocks.field_150355_j) continue;
            ++cov;
        }
        return cov;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return this.isValidFishingrod(stack);
        }
        return super.func_94041_b(index, stack);
    }

    public boolean isEquipmentValid() {
        ItemStack equip = this.func_70301_a(0);
        if (equip.func_190926_b()) {
            return false;
        }
        return this.isValidFishingrod(equip);
    }

    public boolean isValidFishingrod(ItemStack equip) {
        return equip.func_77973_b() instanceof ItemFishingRod;
    }

    private boolean isFishCaught() {
        if (this.field_145850_b == null) {
            return false;
        }
        boolean doDaylightCycle = this.field_145850_b.func_82736_K().func_82766_b("doDaylightCycle");
        boolean perChance = doDaylightCycle ? this.field_145850_b.func_72820_D() % 20L == 0L : this.field_145850_b.field_73012_v.nextInt(20) == 0;
        return this.field_145850_b.field_73012_v.nextDouble() < this.getFishSpeed() && this.isValidPosition() && this.isEquipmentValid() && perChance;
    }

    public void func_73660_a() {
        if (!this.isRunning() || !this.isEquipmentValid()) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        World world = this.func_145831_w();
        Random rand = world.field_73012_v;
        if (this.isFishCaught() && world instanceof WorldServer) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)world);
            int luck = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_151370_z, (ItemStack)this.func_70301_a(0));
            lootcontext$builder.func_186469_a((float)luck);
            LootTableManager loot = world.func_184146_ak();
            if (loot == null) {
                return;
            }
            LootTable table = loot.func_186521_a(LootTableList.field_186387_al);
            if (table == null) {
                return;
            }
            LootContext context = lootcontext$builder.func_186471_a();
            if (context == null) {
                return;
            }
            for (ItemStack itemstack : table.func_186462_a(rand, context)) {
                UtilParticle.spawnParticle(world, EnumParticleTypes.WATER_WAKE, this.field_174879_c.func_177984_a());
                int mending = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)this.func_70301_a(0));
                if (mending == 0) {
                    this.damageTool();
                } else if (rand.nextDouble() < 0.25) {
                    this.damageTool();
                } else if (rand.nextDouble() < 0.6) {
                    this.attemptRepairTool();
                }
                this.sendOutputItem(itemstack);
            }
        }
    }

    private void sendOutputItem(ItemStack itemstack) {
        for (int i = 1; i <= 15; ++i) {
            if (itemstack.func_190926_b() || itemstack.func_77976_d() == 0) continue;
            itemstack = this.tryMergeStackIntoSlot(itemstack, i);
        }
        if (!itemstack.func_190926_b() && itemstack.func_77976_d() != 0) {
            UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.field_174879_c.func_177977_b(), itemstack);
        }
    }

    public double getFishSpeed() {
        int mult = this.countWaterFlowing() * 4 + this.countWater();
        double randFact = 0.0;
        if (Math.random() > 0.9) {
            randFact = Math.random() / 10000.0;
        }
        return (double)((float)mult * 8.9E-4f) + randFact;
    }

    private void attemptRepairTool() {
        ItemStack equip = this.func_70301_a(0);
        if (!equip.func_190926_b() && equip.func_77952_i() > 0) {
            equip.func_77964_b(equip.func_77952_i() - 1);
        }
    }

    private void damageTool() {
        IEnergyStorage storage;
        ItemStack equip = this.func_70301_a(0);
        if (equip.func_190926_b()) {
            return;
        }
        if (equip.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)equip.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            storage.extractEnergy(100, false);
            if (storage.getEnergyStored() <= 0) {
                this.sendOutputItem(equip);
                this.func_70299_a(0, ItemStack.field_190927_a);
            }
            return;
        }
        equip.func_96631_a(1, this.func_145831_w().field_73012_v, null);
        int damageRem = equip.func_77958_k() - equip.func_77952_i();
        if (damageRem == 1 && EnchantmentHelper.func_82781_a((ItemStack)equip).size() > 0) {
            this.sendOutputItem(equip);
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
        if (equip.func_77952_i() >= equip.func_77958_k()) {
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e("redstone");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(tagCompound);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
            }
        }
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(this.func_174890_g());
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    public static enum Fields {
        REDSTONE;

    }
}

