/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.fan;

import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.core.util.UtilParticle;
import com.lothrazar.cyclicmagic.core.util.UtilShape;
import com.lothrazar.cyclicmagic.gui.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityFan
extends TileEntityBaseMachineInvo
implements ITickable,
ITileRedstoneToggle,
ITilePreviewToggle {
    private static final int MIN_RANGE = 1;
    private static final int TIMER_FULL = 30;
    public static final int MAX_SPEED = 10;
    public static final int MAX_RANGE = 32;
    private static final String NBT_PART = "particles";
    private static final String NBT_PUSH = "pushpull";
    private static final String NBT_RANGE = "range";
    private int timer;
    private int needsRedstone = 1;
    private int pushIfZero = 0;
    private int showParticles = 0;
    private int range = 16;

    public TileEntityFan() {
        super(0);
        this.speed = 5;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            this.timer = 0;
            return;
        }
        if (this.timer == 0) {
            this.timer = 30;
            if (this.isPreviewVisible()) {
                this.doParticles();
            }
        } else {
            --this.timer;
        }
        this.pushEntities();
    }

    @Override
    public List<BlockPos> getShape() {
        return UtilShape.line(this.func_174877_v(), this.getCurrentFacing(), this.getCurrentRange());
    }

    private int pushEntities() {
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return 0;
        }
        BlockPos start = shape.get(0);
        BlockPos end = shape.get(shape.size() - 1);
        switch (this.getCurrentFacing().func_176740_k()) {
            case X: {
                end = end.func_177982_a(0, 0, 1);
                end = end.func_177982_a(0, 1, 0);
                break;
            }
            case Z: {
                end = end.func_177982_a(1, 0, 0);
                end = end.func_177982_a(0, 1, 0);
                break;
            }
            case Y: {
                start = start.func_177982_a(1, 0, 0);
                end = end.func_177982_a(0, 0, 1);
            }
        }
        EnumFacing face = this.getCurrentFacing();
        switch (face) {
            case NORTH: {
                start = start.func_177968_d();
                break;
            }
            case SOUTH: {
                end = end.func_177968_d();
                break;
            }
            case EAST: {
                end = end.func_177974_f();
                break;
            }
            case WEST: {
                start = start.func_177974_f();
                break;
            }
            case DOWN: {
                break;
            }
        }
        AxisAlignedBB region = new AxisAlignedBB(start, end);
        List entitiesFound = this.func_145831_w().func_72872_a(Entity.class, region);
        int moved = 0;
        boolean doPush = this.pushIfZero == 0;
        int direction = 1;
        float SPEED = this.getSpeedCalc();
        for (Entity entity : entitiesFound) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af()) continue;
            ++moved;
            switch (face) {
                case NORTH: {
                    direction = !doPush ? 1 : -1;
                    entity.field_70179_y += (double)((float)direction * SPEED);
                    break;
                }
                case SOUTH: {
                    direction = doPush ? 1 : -1;
                    entity.field_70179_y += (double)((float)direction * SPEED);
                    break;
                }
                case EAST: {
                    direction = doPush ? 1 : -1;
                    entity.field_70159_w += (double)((float)direction * SPEED);
                    break;
                }
                case WEST: {
                    direction = !doPush ? 1 : -1;
                    entity.field_70159_w += (double)((float)direction * SPEED);
                    break;
                }
                case DOWN: {
                    direction = !doPush ? 1 : -1;
                    entity.field_70181_x += (double)((float)direction * SPEED);
                    break;
                }
                case UP: {
                    direction = doPush ? 1 : -1;
                    entity.field_70181_x += (double)((float)direction * SPEED);
                }
            }
        }
        return moved;
    }

    private float getSpeedCalc() {
        return (float)this.speed / 35.0f;
    }

    private void doParticles() {
        List<BlockPos> shape = this.getShape();
        for (BlockPos pos : shape) {
            UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CLOUD, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1);
        }
    }

    private int getCurrentRange() {
        EnumFacing facing = this.getCurrentFacing();
        for (int i = 1; i <= this.getRange(); ++i) {
            BlockPos tester = this.func_174877_v().func_177967_a(facing, i);
            if (this.canBlowThrough(tester)) continue;
            return i;
        }
        return this.getRange();
    }

    public int getRange() {
        return this.range;
    }

    private void setRange(int value) {
        this.range = Math.min(value, 32);
        if (this.range < 1) {
            this.range = 1;
        }
    }

    private boolean canBlowThrough(BlockPos tester) {
        return this.func_145831_w().func_175623_d(tester) || !this.func_145831_w().func_180495_p(tester).func_185913_b();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a("Timer", this.timer);
        tags.func_74768_a("redstone", this.needsRedstone);
        tags.func_74768_a(NBT_PART, this.showParticles);
        tags.func_74768_a(NBT_PUSH, this.pushIfZero);
        tags.func_74768_a(NBT_RANGE, this.range);
        return super.func_189515_b(tags);
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.timer = tags.func_74762_e("Timer");
        this.needsRedstone = tags.func_74762_e("redstone");
        this.showParticles = tags.func_74762_e(NBT_PART);
        this.pushIfZero = tags.func_74762_e(NBT_PUSH);
        this.range = tags.func_74762_e(NBT_RANGE);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val % 2);
    }

    private void setShowParticles(int value) {
        this.showParticles = value % 2;
    }

    private void setPushPull(int value) {
        this.pushIfZero = value % 2;
        this.func_70296_d();
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
                case PARTICLES: {
                    return this.showParticles;
                }
                case PUSHPULL: {
                    return this.pushIfZero;
                }
                case RANGE: {
                    return this.range;
                }
                case SPEED: {
                    return this.speed;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                    break;
                }
                case PARTICLES: {
                    this.setShowParticles(value);
                    break;
                }
                case PUSHPULL: {
                    this.setPushPull(value);
                    break;
                }
                case RANGE: {
                    this.setRange(value);
                    break;
                }
                case SPEED: {
                    this.setSpeed(value);
                }
            }
        }
    }

    @Override
    public void setSpeed(int value) {
        if (value < 1) {
            value = 1;
        }
        this.speed = Math.min(value, 10);
    }

    @Override
    public void togglePreview() {
        this.showParticles = (this.showParticles + 1) % 2;
    }

    @Override
    public boolean isPreviewVisible() {
        return this.showParticles == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        PARTICLES,
        PUSHPULL,
        RANGE,
        SPEED;

    }
}

