/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.enchantlibrary;

import com.lothrazar.cyclicmagic.block.enchantlibrary.EnchantStack;
import com.lothrazar.cyclicmagic.block.enchantlibrary.QuadrantEnum;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachine;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;

public class TileEntityLibrary
extends TileEntityBaseMachine
implements ITickable {
    public static final int MAX_COUNT = 64;
    private static final int HEADER_TIMER = 10;
    private static final String NBT_CLICKED = "lastClicked";
    EnchantStack[] storage = new EnchantStack[QuadrantEnum.values().length];
    QuadrantEnum lastClicked = null;
    private int timer = 0;

    public TileEntityLibrary() {
        for (int i = 0; i < this.storage.length; ++i) {
            this.storage[i] = new EnchantStack();
        }
    }

    public void func_73660_a() {
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.timer == 0) {
            this.lastClicked = null;
        }
    }

    public EnchantStack getEnchantStack(QuadrantEnum area) {
        return this.storage[area.ordinal()];
    }

    public void removeEnchantment(QuadrantEnum area) {
        this.storage[area.ordinal()].remove();
    }

    public boolean addEnchantment(QuadrantEnum area, Enchantment ench, int level) {
        int index = area.ordinal();
        EnchantStack enchStackCurrent = this.storage[index];
        if (enchStackCurrent.getCount() >= 64) {
            return false;
        }
        if (enchStackCurrent.isEmpty()) {
            this.storage[index] = enchStackCurrent = new EnchantStack(ench, level);
            return true;
        }
        if (enchStackCurrent.doesMatch(ench, level)) {
            enchStackCurrent.add();
            this.storage[index] = enchStackCurrent;
            return true;
        }
        return false;
    }

    public boolean addEnchantmentFromPlayer(EntityPlayer player, EnumHand hand, QuadrantEnum segment) {
        Enchantment enchToRemove = null;
        ItemStack playerHeld = player.func_184586_b(hand);
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)playerHeld);
        for (Map.Entry entry : enchants.entrySet()) {
            if (!this.addEnchantment(segment, (Enchantment)entry.getKey(), (Integer)entry.getValue())) continue;
            enchToRemove = (Enchantment)entry.getKey();
            break;
        }
        if (enchToRemove != null) {
            if (enchants.size() == 1) {
                player.func_184611_a(hand, new ItemStack(Items.field_151122_aG));
                player.func_184811_cZ().func_185145_a(Items.field_151122_aG, 50);
            } else {
                enchants.remove(enchToRemove);
                ItemStack inputCopy = new ItemStack(Items.field_151134_bR);
                EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)inputCopy);
                player.func_184611_a(hand, inputCopy);
            }
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.timer = tags.func_74762_e("t");
        if (tags.func_74764_b(NBT_CLICKED)) {
            this.lastClicked = QuadrantEnum.values()[tags.func_74762_e(NBT_CLICKED)];
        }
        for (QuadrantEnum q : QuadrantEnum.values()) {
            EnchantStack s = new EnchantStack();
            s.readFromNBT(tags, q.name());
            this.storage[q.ordinal()] = s;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        for (QuadrantEnum q : QuadrantEnum.values()) {
            tags.func_74782_a(q.name(), (NBTBase)this.getEnchantStack(q).writeToNBT());
        }
        if (this.lastClicked != null) {
            tags.func_74768_a(NBT_CLICKED, this.lastClicked.ordinal());
        }
        tags.func_74768_a("t", this.timer);
        return super.func_189515_b(tags);
    }

    public void setLastClicked(QuadrantEnum segment) {
        this.timer = 200;
        this.lastClicked = segment;
    }

    public QuadrantEnum getLastClicked() {
        return this.lastClicked;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.storage.length; ++i) {
            if (this.storage[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public QuadrantEnum findEmptyQuadrant() {
        for (int i = 0; i < this.storage.length; ++i) {
            if (!this.storage[i].isEmpty()) continue;
            return QuadrantEnum.values()[i];
        }
        return null;
    }

    public QuadrantEnum findMatchingQuadrant(ItemStack enchBookStack) {
        for (int i = 0; i < this.storage.length; ++i) {
            if (!this.storage[i].doesMatchNonEmpty(enchBookStack)) continue;
            return QuadrantEnum.values()[i];
        }
        return null;
    }
}

