/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.enchantlibrary;

import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.registry.EnchantRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class EnchantStack {
    private static final String NBT_LEVEL = "level";
    private static final String NBT_COUNT = "eCount";
    private static final String NBT_ENCH = "ench";
    private int count = 0;
    private int level = 0;
    private Enchantment ench = null;

    public EnchantStack() {
    }

    public EnchantStack(Enchantment e, int lvl) {
        this.ench = e;
        this.level = lvl;
        this.count = 1;
    }

    public Enchantment getEnch() {
        return this.ench;
    }

    public Integer getLevel() {
        return this.level;
    }

    public int getCount() {
        return this.count;
    }

    public void readFromNBT(NBTTagCompound tags, String key) {
        NBTTagCompound t = (NBTTagCompound)tags.func_74781_a(key);
        this.count = t.func_74762_e(NBT_COUNT);
        this.level = t.func_74762_e(NBT_LEVEL);
        String enchString = t.func_74779_i(NBT_ENCH);
        if (!enchString.isEmpty()) {
            this.ench = Enchantment.func_180305_b((String)enchString);
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound t = new NBTTagCompound();
        t.func_74768_a(NBT_COUNT, this.count);
        t.func_74768_a(NBT_LEVEL, this.level);
        if (this.ench == null) {
            t.func_74778_a(NBT_ENCH, "");
        } else {
            t.func_74778_a(NBT_ENCH, this.ench.getRegistryName().toString());
        }
        return t;
    }

    public boolean isEmpty() {
        return this.ench == null || this.getCount() == 0;
    }

    public boolean doesMatchNonEmpty(ItemStack stack) {
        if (this.isEmpty()) {
            return false;
        }
        if (stack.func_77973_b().equals(Items.field_151134_bR)) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
            for (Map.Entry entry : enchants.entrySet()) {
                if (!this.doesMatch((Enchantment)entry.getKey(), (Integer)entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doesMatch(Enchantment e, int lvl) {
        return this.ench.equals(e) && this.level == lvl;
    }

    public void add() {
        ++this.count;
    }

    public void remove() {
        --this.count;
        if (this.count <= 0) {
            this.ench = null;
            this.level = 0;
        }
    }

    public boolean equals(EnchantStack e) {
        return this.doesMatch(e.ench, e.getLevel()) && this.getCount() == e.getCount();
    }

    public String toString() {
        if (this.isEmpty()) {
            return UtilChat.lang("enchantment_stack.empty");
        }
        return this.countName() + " " + UtilChat.lang(this.ench.func_77320_a()) + " " + this.levelName();
    }

    public String countName() {
        return "[" + this.count + "]";
    }

    public String levelName() {
        return EnchantRegistry.getStrForLevel(this.level);
    }

    public String shortName() {
        if (this.isEmpty()) {
            return "--";
        }
        return UtilChat.lang(this.ench.func_77320_a()).substring(0, 5);
    }

    public ItemStack getRenderIcon() {
        return this.makeEnchantedBook();
    }

    public ItemStack makeEnchantedBook() {
        if (this.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(Items.field_151134_bR);
        HashMap<Enchantment, Integer> enchMap = new HashMap<Enchantment, Integer>();
        enchMap.put(this.getEnch(), this.getLevel());
        EnchantmentHelper.func_82782_a(enchMap, (ItemStack)stack);
        return stack;
    }
}

