/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.enchantlibrary;

import com.lothrazar.cyclicmagic.block.enchantlibrary.EnchantStack;
import com.lothrazar.cyclicmagic.block.enchantlibrary.LibraryTESR;
import com.lothrazar.cyclicmagic.block.enchantlibrary.QuadrantEnum;
import com.lothrazar.cyclicmagic.block.enchantlibrary.TileEntityLibrary;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBaseFacing;
import com.lothrazar.cyclicmagic.core.block.IBlockHasTESR;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLibrary
extends BlockBaseFacing
implements IBlockHasTESR,
IHasRecipe {
    public BlockLibrary() {
        super(Material.field_151575_d);
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityLibrary();
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing.func_176734_d());
    }

    @Override
    public EnumFacing getFacingFromState(IBlockState state) {
        return super.getFacingFromState(state).func_176734_d();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side != this.getFacingFromState(state)) {
            return false;
        }
        TileEntityLibrary library = (TileEntityLibrary)world.func_175625_s(pos);
        QuadrantEnum segment = QuadrantEnum.getForFace(side, hitX, hitY, hitZ);
        if (segment == null) {
            return false;
        }
        library.setLastClicked(segment);
        ItemStack playerHeld = player.func_184586_b(hand);
        if (playerHeld.func_77973_b().equals(Items.field_151134_bR)) {
            if (library.addEnchantmentFromPlayer(player, hand, segment)) {
                this.onSuccess(player);
                library.func_70296_d();
                return true;
            }
        } else if (playerHeld.func_77973_b().equals(Items.field_151122_aG) && !player.func_184811_cZ().func_185141_a(Items.field_151122_aG)) {
            EnchantStack es = library.getEnchantStack(segment);
            if (!es.isEmpty()) {
                UtilChat.sendStatusMessage(player, UtilChat.lang(es.getEnch().func_77320_a()) + " " + es.levelName());
                this.dropEnchantedBookOnPlayer(es, player, pos);
                playerHeld.func_190918_g(1);
                library.removeEnchantment(segment);
                this.onSuccess(player);
                library.func_70296_d();
                return true;
            }
        } else if (!player.func_70093_af()) {
            EnchantStack es = library.getEnchantStack(segment);
            UtilChat.sendStatusMessage(player, es.toString());
            library.func_70296_d();
            return true;
        }
        return false;
    }

    private void onSuccess(EntityPlayer player) {
        UtilSound.playSound(player, SoundEvents.field_190021_aL);
    }

    private void dropEnchantedBookOnPlayer(EnchantStack ench, EntityPlayer player, BlockPos pos) {
        ItemStack stack = ench.makeEnchantedBook();
        if (!player.func_191521_c(stack)) {
            player.func_71019_a(stack, true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLibrary.class, new LibraryTESR(this));
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 4), " r ", "sgs", " r ", Character.valueOf('g'), Blocks.field_150342_X, Character.valueOf('s'), Blocks.field_185767_cT, Character.valueOf('r'), "obsidian");
    }
}

